/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.model.NottableSchemaString;
import org.mockserver.model.NottableString;
import org.slf4j.event.Level;

public class RegexStringMatcher
extends BodyMatcher<NottableString> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger"};
    private final MockServerLogger mockServerLogger;
    private final NottableString matcher;
    private final boolean controlPlaneMatcher;

    public RegexStringMatcher(MockServerLogger mockServerLogger, boolean controlPlaneMatcher) {
        this.mockServerLogger = mockServerLogger;
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = null;
    }

    RegexStringMatcher(MockServerLogger mockServerLogger, NottableString matcher, boolean controlPlaneMatcher) {
        this.mockServerLogger = mockServerLogger;
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = matcher;
    }

    public boolean matches(String matched) {
        return this.matches((MatchDifference)null, NottableString.string(matched));
    }

    @Override
    public boolean matches(MatchDifference context, NottableString matched) {
        boolean result = false;
        if (this.matcher == null || this.matches(this.matcher, matched, true)) {
            result = true;
        }
        if (!result && context != null) {
            context.addDifference(this.mockServerLogger, "string or regex match failed expected:{}found:{}", this.matcher, matched);
        }
        return this.not != result;
    }

    public boolean matches(NottableString matcher, NottableString matched, boolean ignoreCase) {
        if (matcher instanceof NottableSchemaString && matched instanceof NottableSchemaString) {
            return this.controlPlaneMatcher && this.matchesByStrings(matcher, matched, ignoreCase);
        }
        if (matcher instanceof NottableSchemaString) {
            return this.matchesBySchemas((NottableSchemaString)matcher, matched);
        }
        if (matched instanceof NottableSchemaString) {
            return this.controlPlaneMatcher && this.matchesBySchemas((NottableSchemaString)matched, matcher);
        }
        return this.matchesByStrings(matcher, matched, ignoreCase);
    }

    private boolean matchesByStrings(NottableString matcher, NottableString matched, boolean ignoreCase) {
        if (matcher.isNot() && matched.isNot()) {
            return this.matches(matcher.getValue(), matched.getValue(), ignoreCase);
        }
        return (matcher.isNot() || matched.isNot()) ^ this.matches(matcher.getValue(), matched.getValue(), ignoreCase);
    }

    private boolean matchesBySchemas(NottableSchemaString schema, NottableString string) {
        return string.isNot() != schema.matches(string.getValue());
    }

    public boolean matches(String matcher, String matched, boolean ignoreCase) {
        block21: {
            if (StringUtils.isBlank((CharSequence)matcher)) {
                return true;
            }
            if (matched != null) {
                block19: {
                    block18: {
                        if (matched.equals(matcher)) {
                            return true;
                        }
                        try {
                            if (matched.matches(matcher)) {
                                return true;
                            }
                        }
                        catch (PatternSyntaxException pse) {
                            if (!MockServerLogger.isEnabled(Level.DEBUG)) break block18;
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("error while matching regex [" + matcher + "] for string [" + matched + "] " + pse.getMessage()).setThrowable(pse));
                        }
                    }
                    try {
                        if (this.controlPlaneMatcher && matcher.matches(matched)) {
                            return true;
                        }
                        if (MockServerLogger.isEnabled(Level.DEBUG) && matcher.matches(matched)) {
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("matcher{}would match{}if matcher was used for control plane").setArguments(matcher, matched));
                        }
                    }
                    catch (PatternSyntaxException pse) {
                        if (!MockServerLogger.isEnabled(Level.DEBUG)) break block19;
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("error while matching regex [" + matched + "] for string [" + matcher + "] " + pse.getMessage()).setThrowable(pse));
                    }
                }
                if (ignoreCase) {
                    block20: {
                        if (matched.equalsIgnoreCase(matcher)) {
                            return true;
                        }
                        try {
                            if (matched.toLowerCase().matches(matcher.toLowerCase())) {
                                return true;
                            }
                        }
                        catch (PatternSyntaxException pse) {
                            if (!MockServerLogger.isEnabled(Level.DEBUG)) break block20;
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("error while matching regex [" + matcher.toLowerCase() + "] for string [" + matched.toLowerCase() + "] " + pse.getMessage()).setThrowable(pse));
                        }
                    }
                    try {
                        if (this.controlPlaneMatcher && matcher.toLowerCase().matches(matched.toLowerCase())) {
                            return true;
                        }
                    }
                    catch (PatternSyntaxException pse) {
                        if (!MockServerLogger.isEnabled(Level.DEBUG)) break block21;
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("error while matching regex [" + matched.toLowerCase() + "] for string [" + matcher.toLowerCase() + "] " + pse.getMessage()).setThrowable(pse));
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || StringUtils.isBlank((CharSequence)this.matcher.getValue());
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

