/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class Times
extends ObjectWithReflectiveEqualsHashCodeToString {
    private static final Times TIMES_UNLIMITED = new Times(-1, true){

        @Override
        public final int getRemainingTimes() {
            return -1;
        }

        @Override
        public final boolean isUnlimited() {
            return true;
        }

        @Override
        public final boolean greaterThenZero() {
            return true;
        }

        @Override
        public final boolean decrement() {
            return false;
        }
    };
    private int remainingTimes;
    private final boolean unlimited;

    private Times(int remainingTimes, boolean unlimited) {
        this.remainingTimes = remainingTimes;
        this.unlimited = unlimited;
    }

    public static Times unlimited() {
        return TIMES_UNLIMITED;
    }

    public static Times once() {
        return new Times(1, false);
    }

    public static Times exactly(int count) {
        return new Times(count, false);
    }

    public int getRemainingTimes() {
        return this.remainingTimes;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public boolean greaterThenZero() {
        return this.unlimited || this.remainingTimes > 0;
    }

    public boolean decrement() {
        if (!this.unlimited) {
            --this.remainingTimes;
            return true;
        }
        return false;
    }

    public Times clone() {
        if (this.unlimited) {
            return Times.unlimited();
        }
        return Times.exactly(this.remainingTimes);
    }
}

