/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.mockserver.closurecallback.websocketregistry.WebSocketClientRegistry;
import org.mockserver.collections.CircularPriorityQueue;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.metrics.Metrics;
import org.mockserver.mock.Expectation;
import org.mockserver.model.Action;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.RequestDefinition;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.ui.MockServerMatcherNotifier;
import org.slf4j.event.Level;

public class RequestMatchers
extends MockServerMatcherNotifier {
    final CircularPriorityQueue<String, HttpRequestMatcher> httpRequestMatchers = new CircularPriorityQueue<String, HttpRequestMatcher>(ConfigurationProperties.maxExpectations(), HttpRequestMatcher.class, HttpRequestMatcher.EXPECTATION_PRIORITY_COMPARATOR, httpRequestMatcher -> httpRequestMatcher.getExpectation().getId());
    private final AtomicReference<List<HttpRequestMatcher>> httpRequestMatchersCopy = new AtomicReference();
    private final MockServerLogger mockServerLogger;
    private final Scheduler scheduler;
    private WebSocketClientRegistry webSocketClientRegistry;
    private MatcherBuilder matcherBuilder;

    public RequestMatchers(MockServerLogger mockServerLogger, Scheduler scheduler, WebSocketClientRegistry webSocketClientRegistry) {
        super(scheduler);
        this.scheduler = scheduler;
        this.matcherBuilder = new MatcherBuilder(mockServerLogger);
        this.mockServerLogger = mockServerLogger;
        this.webSocketClientRegistry = webSocketClientRegistry;
    }

    public Expectation add(Expectation expectation, MockServerMatcherNotifier.Cause cause) {
        Expectation upsertedExpectation = null;
        if (expectation != null) {
            upsertedExpectation = this.httpRequestMatchers.getByKey(expectation.getId()).map(httpRequestMatcher -> {
                if (httpRequestMatcher.getExpectation() != null && httpRequestMatcher.getExpectation().getAction() != null) {
                    Metrics.decrement(httpRequestMatcher.getExpectation().getAction().getType());
                }
                if (httpRequestMatcher.update(expectation)) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.UPDATED_EXPECTATION).setLogLevel(Level.DEBUG).setHttpRequest(expectation.getHttpRequest()).setMessageFormat("updated expectation:{}").setArguments(expectation.clone()));
                    if (expectation.getAction() != null) {
                        Metrics.increment(expectation.getAction().getType());
                    }
                }
                return httpRequestMatcher;
            }).orElseGet(() -> this.addPrioritisedExpectation(expectation)).getExpectation();
            this.notifyListeners(this, cause);
        }
        return upsertedExpectation;
    }

    public void update(Expectation[] expectations, MockServerMatcherNotifier.Cause cause) {
        AtomicInteger numberOfChanges = new AtomicInteger(0);
        if (expectations != null) {
            Map<String, HttpRequestMatcher> httpRequestMatchersByKey = this.httpRequestMatchers.keyMap();
            HashSet<String> existingKeys = new HashSet<String>(httpRequestMatchersByKey.keySet());
            Arrays.stream(expectations).forEach(expectation -> {
                existingKeys.remove(expectation.getId());
                if (httpRequestMatchersByKey.containsKey(expectation.getId())) {
                    HttpRequestMatcher httpRequestMatcher = (HttpRequestMatcher)httpRequestMatchersByKey.get(expectation.getId());
                    if (httpRequestMatcher.getExpectation() != null && httpRequestMatcher.getExpectation().getAction() != null) {
                        Metrics.decrement(httpRequestMatcher.getExpectation().getAction().getType());
                    }
                    if (httpRequestMatcher.update((Expectation)expectation)) {
                        numberOfChanges.getAndIncrement();
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.UPDATED_EXPECTATION).setLogLevel(Level.INFO).setHttpRequest(expectation.getHttpRequest()).setMessageFormat("updated expectation:{}").setArguments(expectation.clone()));
                        if (expectation.getAction() != null) {
                            Metrics.increment(expectation.getAction().getType());
                        }
                    }
                } else {
                    this.addPrioritisedExpectation((Expectation)expectation);
                    numberOfChanges.getAndIncrement();
                }
            });
            existingKeys.forEach(key -> {
                numberOfChanges.getAndIncrement();
                HttpRequestMatcher httpRequestMatcher = (HttpRequestMatcher)httpRequestMatchersByKey.get(key);
                this.removeHttpRequestMatcher(httpRequestMatcher, cause, false);
                if (httpRequestMatcher.getExpectation() != null && httpRequestMatcher.getExpectation().getAction() != null) {
                    Metrics.decrement(httpRequestMatcher.getExpectation().getAction().getType());
                }
            });
            if (numberOfChanges.get() > 0) {
                this.notifyListeners(this, cause);
            }
        }
    }

    private HttpRequestMatcher addPrioritisedExpectation(Expectation expectation) {
        HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(expectation);
        this.httpRequestMatchers.add(httpRequestMatcher);
        if (expectation.getAction() != null) {
            Metrics.increment(expectation.getAction().getType());
        }
        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.CREATED_EXPECTATION).setLogLevel(Level.INFO).setHttpRequest(expectation.getHttpRequest()).setMessageFormat("creating expectation:{}").setArguments(expectation.clone()));
        return httpRequestMatcher;
    }

    public int size() {
        return this.httpRequestMatchers.size();
    }

    public void setMaxSize(int maxSize) {
        this.httpRequestMatchers.setMaxSize(maxSize);
    }

    public void reset(MockServerMatcherNotifier.Cause cause) {
        new ArrayList<HttpRequestMatcher>(this.httpRequestMatchers).forEach(httpRequestMatcher -> this.removeHttpRequestMatcher((HttpRequestMatcher)httpRequestMatcher, cause, false));
        Metrics.clearActionMetrics();
        this.notifyListeners(this, cause);
    }

    public void reset() {
        this.reset(MockServerMatcherNotifier.Cause.API);
    }

    public Expectation firstMatchingExpectation(HttpRequest httpRequest) {
        Expectation matchingExpectation = null;
        for (HttpRequestMatcher httpRequestMatcher : this.getHttpRequestMatchersCopy()) {
            boolean remainingMatchesDecremented = false;
            if (httpRequestMatcher.matches(MockServerLogger.isEnabled(Level.DEBUG) ? new MatchDifference(httpRequest) : null, httpRequest)) {
                matchingExpectation = httpRequestMatcher.getExpectation();
                httpRequestMatcher.setResponseInProgress(true);
                if (matchingExpectation.decrementRemainingMatches()) {
                    remainingMatchesDecremented = true;
                }
            } else if (!httpRequestMatcher.isResponseInProgress() && !httpRequestMatcher.isActive()) {
                this.scheduler.submit(() -> this.removeHttpRequestMatcher(httpRequestMatcher));
            }
            if (remainingMatchesDecremented) {
                this.notifyListeners(this, MockServerMatcherNotifier.Cause.API);
            }
            if (matchingExpectation == null) continue;
            break;
        }
        if (ConfigurationProperties.metricsEnabled()) {
            if (matchingExpectation == null || matchingExpectation.getAction() == null) {
                Metrics.increment(Metrics.Name.EXPECTATION_NOT_MATCHED_COUNT);
            } else if (matchingExpectation.getAction().getType().direction == Action.Direction.FORWARD) {
                Metrics.increment(Metrics.Name.FORWARD_EXPECTATION_MATCHED_COUNT);
            } else {
                Metrics.increment(Metrics.Name.RESPONSE_EXPECTATION_MATCHED_COUNT);
            }
        }
        return matchingExpectation;
    }

    public void clear(RequestDefinition requestDefinition) {
        if (requestDefinition != null) {
            HttpRequestMatcher clearHttpRequestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinition);
            for (HttpRequestMatcher httpRequestMatcher : this.getHttpRequestMatchersCopy()) {
                RequestDefinition request = httpRequestMatcher.getExpectation().getHttpRequest().clone().withLogCorrelationId(requestDefinition.getLogCorrelationId());
                if (!clearHttpRequestMatcher.matches(request)) continue;
                this.removeHttpRequestMatcher(httpRequestMatcher);
            }
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.CLEARED).setLogLevel(Level.INFO).setCorrelationId(requestDefinition.getLogCorrelationId()).setHttpRequest(requestDefinition).setMessageFormat("cleared expectations that match:{}").setArguments(requestDefinition));
        } else {
            this.reset();
        }
    }

    Expectation postProcess(Expectation expectation) {
        if (expectation != null) {
            for (HttpRequestMatcher httpRequestMatcher : this.getHttpRequestMatchersCopy()) {
                if (httpRequestMatcher.getExpectation() != expectation) continue;
                if (!expectation.isActive()) {
                    this.removeHttpRequestMatcher(httpRequestMatcher);
                    break;
                }
                httpRequestMatcher.setResponseInProgress(false);
            }
        }
        return expectation;
    }

    private void removeHttpRequestMatcher(HttpRequestMatcher httpRequestMatcher) {
        this.removeHttpRequestMatcher(httpRequestMatcher, MockServerMatcherNotifier.Cause.API, true);
    }

    private void removeHttpRequestMatcher(HttpRequestMatcher httpRequestMatcher, MockServerMatcherNotifier.Cause cause, boolean notifyAndUpdateMetrics) {
        if (this.httpRequestMatchers.remove(httpRequestMatcher)) {
            if (httpRequestMatcher.getExpectation() != null) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.REMOVED_EXPECTATION).setLogLevel(Level.INFO).setHttpRequest(httpRequestMatcher.getExpectation().getHttpRequest()).setMessageFormat("removed expectation:{}").setArguments(httpRequestMatcher.getExpectation().clone()));
            }
            if (httpRequestMatcher.getExpectation() != null) {
                Action action = httpRequestMatcher.getExpectation().getAction();
                if (action instanceof HttpObjectCallback) {
                    this.webSocketClientRegistry.unregisterClient(((HttpObjectCallback)action).getClientId());
                }
                if (notifyAndUpdateMetrics && action != null) {
                    Metrics.decrement(action.getType());
                }
            }
            if (notifyAndUpdateMetrics) {
                this.notifyListeners(this, cause);
            }
        }
    }

    public List<Expectation> retrieveActiveExpectations(RequestDefinition requestDefinition) {
        if (requestDefinition == null) {
            return this.httpRequestMatchers.stream().map(HttpRequestMatcher::getExpectation).collect(Collectors.toList());
        }
        ArrayList<Expectation> expectations = new ArrayList<Expectation>();
        HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinition);
        for (HttpRequestMatcher httpRequestMatcher : this.getHttpRequestMatchersCopy()) {
            if (!requestMatcher.matches(httpRequestMatcher.getExpectation().getHttpRequest())) continue;
            expectations.add(httpRequestMatcher.getExpectation());
        }
        return expectations;
    }

    public List<HttpRequestMatcher> retrieveRequestMatchers(RequestDefinition requestDefinition) {
        if (requestDefinition == null) {
            return new ArrayList<HttpRequestMatcher>(this.httpRequestMatchers);
        }
        ArrayList<HttpRequestMatcher> httpRequestMatchers = new ArrayList<HttpRequestMatcher>();
        HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinition);
        for (HttpRequestMatcher httpRequestMatcher : this.getHttpRequestMatchersCopy()) {
            if (!requestMatcher.matches(httpRequestMatcher.getExpectation().getHttpRequest())) continue;
            httpRequestMatchers.add(httpRequestMatcher);
        }
        return httpRequestMatchers;
    }

    public boolean isEmpty() {
        return this.httpRequestMatchers.isEmpty();
    }

    @Override
    protected void notifyListeners(RequestMatchers notifier, MockServerMatcherNotifier.Cause cause) {
        this.httpRequestMatchersCopy.set(null);
        super.notifyListeners(notifier, cause);
    }

    private List<HttpRequestMatcher> getHttpRequestMatchersCopy() {
        this.httpRequestMatchersCopy.compareAndSet(null, this.httpRequestMatchers.toSortedList());
        return this.httpRequestMatchersCopy.get();
    }
}

