/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.mockserver.model.Delay;
import org.mockserver.model.ObjectWithJsonToString;

public abstract class Action<T extends Action>
extends ObjectWithJsonToString {
    private int hashCode;
    private Delay delay;

    public T withDelay(Delay delay) {
        this.delay = delay;
        this.hashCode = 0;
        return (T)this;
    }

    public T withDelay(TimeUnit timeUnit, long value) {
        this.delay = new Delay(timeUnit, value);
        return (T)this;
    }

    public Delay getDelay() {
        return this.delay;
    }

    @JsonIgnore
    public abstract Type getType();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        Action action = (Action)o;
        return Objects.equals(this.delay, action.delay);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.delay);
        }
        return this.hashCode;
    }

    public static enum Direction {
        FORWARD,
        RESPONSE;

    }

    public static enum Type {
        FORWARD(Direction.FORWARD),
        FORWARD_TEMPLATE(Direction.FORWARD),
        FORWARD_CLASS_CALLBACK(Direction.FORWARD),
        FORWARD_OBJECT_CALLBACK(Direction.FORWARD),
        FORWARD_REPLACE(Direction.FORWARD),
        RESPONSE(Direction.RESPONSE),
        RESPONSE_TEMPLATE(Direction.RESPONSE),
        RESPONSE_CLASS_CALLBACK(Direction.RESPONSE),
        RESPONSE_OBJECT_CALLBACK(Direction.RESPONSE),
        ERROR(Direction.RESPONSE);

        public final Direction direction;

        private Type(Direction direction) {
            this.direction = direction;
        }
    }
}

