/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import org.mockserver.model.KeyAndValue;
import org.mockserver.model.NottableOptionalString;
import org.mockserver.model.NottableSchemaString;
import org.mockserver.model.NottableString;

public class Cookie
extends KeyAndValue {
    public Cookie(String name, String value) {
        super(name, value);
    }

    public Cookie(NottableString name, NottableString value) {
        super(name, value);
    }

    public static Cookie cookie(String name, String value) {
        return new Cookie(name, value);
    }

    public static Cookie cookie(NottableString name, NottableString value) {
        return new Cookie(name, value);
    }

    public static Cookie schemaCookie(String name, String value) {
        return new Cookie(NottableString.string(name), NottableSchemaString.schemaString(value));
    }

    public static Cookie optionalCookie(String name, String value) {
        return new Cookie(NottableOptionalString.optionalString(name), NottableString.string(value));
    }

    public static Cookie optionalCookie(String name, NottableString value) {
        return new Cookie(NottableOptionalString.optionalString(name), value);
    }
}

