/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import org.mockserver.matchers.MatchType;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.MediaType;
import org.mockserver.serialization.ObjectMapperFactory;

public class JsonBody
extends BodyWithContentType<String> {
    private int hashCode;
    public static final MatchType DEFAULT_MATCH_TYPE = MatchType.ONLY_MATCHING_FIELDS;
    public static final MediaType DEFAULT_JSON_CONTENT_TYPE = MediaType.APPLICATION_JSON_UTF_8;
    private final String json;
    private final MatchType matchType;
    private final byte[] rawBytes;

    public JsonBody(String json) {
        this(json, null, DEFAULT_JSON_CONTENT_TYPE, DEFAULT_MATCH_TYPE);
    }

    public JsonBody(String json, MatchType matchType) {
        this(json, null, DEFAULT_JSON_CONTENT_TYPE, matchType);
    }

    public JsonBody(String json, Charset charset, MatchType matchType) {
        this(json, null, charset != null ? DEFAULT_JSON_CONTENT_TYPE.withCharset(charset) : null, matchType);
    }

    public JsonBody(String json, byte[] rawBytes, MediaType contentType, MatchType matchType) {
        super(Body.Type.JSON, contentType);
        this.json = json;
        this.matchType = matchType;
        this.rawBytes = rawBytes == null && json != null ? json.getBytes(this.determineCharacterSet(contentType, MediaType.DEFAULT_HTTP_CHARACTER_SET)) : rawBytes;
    }

    public static JsonBody json(String json) {
        return new JsonBody(json);
    }

    public static JsonBody json(String json, MatchType matchType) {
        return new JsonBody(json, matchType);
    }

    public static JsonBody json(String json, Charset charset) {
        return new JsonBody(json, null, charset != null ? DEFAULT_JSON_CONTENT_TYPE.withCharset(charset) : null, DEFAULT_MATCH_TYPE);
    }

    public static JsonBody json(String json, Charset charset, MatchType matchType) {
        return new JsonBody(json, null, charset != null ? DEFAULT_JSON_CONTENT_TYPE.withCharset(charset) : null, matchType);
    }

    public static JsonBody json(String json, MediaType contentType) {
        return new JsonBody(json, null, contentType, DEFAULT_MATCH_TYPE);
    }

    public static JsonBody json(String json, MediaType contentType, MatchType matchType) {
        return new JsonBody(json, null, contentType, matchType);
    }

    private static String toJson(Object object) {
        String json;
        try {
            json = ObjectMapperFactory.createObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("error mapping object for json body to JSON", e);
        }
        return json;
    }

    public static JsonBody json(Object object) {
        return new JsonBody(JsonBody.toJson(object));
    }

    public static JsonBody json(Object object, MatchType matchType) {
        return new JsonBody(JsonBody.toJson(object), matchType);
    }

    public static JsonBody json(Object object, Charset charset) {
        return new JsonBody(JsonBody.toJson(object), null, charset != null ? DEFAULT_JSON_CONTENT_TYPE.withCharset(charset) : null, DEFAULT_MATCH_TYPE);
    }

    public static JsonBody json(Object object, Charset charset, MatchType matchType) {
        return new JsonBody(JsonBody.toJson(object), null, charset != null ? DEFAULT_JSON_CONTENT_TYPE.withCharset(charset) : null, matchType);
    }

    public static JsonBody json(Object object, MediaType contentType) {
        return new JsonBody(JsonBody.toJson(object), null, contentType, DEFAULT_MATCH_TYPE);
    }

    public static JsonBody json(Object object, MediaType contentType, MatchType matchType) {
        return new JsonBody(JsonBody.toJson(object), null, contentType, matchType);
    }

    @Override
    public String getValue() {
        return this.json;
    }

    @Override
    @JsonIgnore
    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    @Override
    public String toString() {
        return this.json;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonBody jsonBody = (JsonBody)o;
        return Objects.equals(this.json, jsonBody.json) && this.matchType == jsonBody.matchType && Arrays.equals(this.rawBytes, jsonBody.rawBytes);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            int result = Objects.hash(new Object[]{super.hashCode(), this.json, this.matchType});
            this.hashCode = 31 * result + Arrays.hashCode(this.rawBytes);
        }
        return this.hashCode;
    }
}

