/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.mockserver.model.NottableString;
import org.mockserver.model.ObjectWithJsonToString;

public class KeyToMultiValue
extends ObjectWithJsonToString {
    private final NottableString name;
    private final List<NottableString> values;
    private Integer hashCode;

    KeyToMultiValue(String name, String ... values) {
        this(NottableString.string(name), NottableString.strings(values));
    }

    KeyToMultiValue(NottableString name, NottableString ... values) {
        this.name = name;
        if (values == null || values.length == 0) {
            this.values = Collections.singletonList(NottableString.string(".*"));
        } else if (values.length == 1) {
            this.values = Collections.singletonList(values[0]);
        } else {
            this.values = new LinkedList<NottableString>();
            for (NottableString value : values) {
                this.values.add(value);
            }
        }
    }

    KeyToMultiValue(String name, Collection<String> values) {
        this(NottableString.string(name), NottableString.strings(values));
    }

    KeyToMultiValue(NottableString name, Collection<NottableString> values) {
        this.name = name;
        this.values = values == null || values.isEmpty() ? Collections.singletonList(NottableString.string(".*")) : new LinkedList<NottableString>(values);
        this.hashCode = Objects.hash(this.name, this.values);
    }

    public NottableString getName() {
        return this.name;
    }

    public List<NottableString> getValues() {
        return this.values;
    }

    public void replaceValues(List<NottableString> values) {
        if (this.values != values) {
            this.values.clear();
            this.values.addAll(values);
        }
    }

    public void addValue(String value) {
        this.addValue(NottableString.string(value));
    }

    private void addValue(NottableString value) {
        if (this.values != null && !this.values.contains(value)) {
            this.values.add(value);
        }
        this.hashCode = Objects.hash(this.name, this.values);
    }

    private void addValues(List<String> values) {
        this.addNottableValues(NottableString.deserializeNottableStrings(values));
    }

    private void addNottableValues(List<NottableString> values) {
        if (this.values != null) {
            for (NottableString value : values) {
                if (this.values.contains(value)) continue;
                this.values.add(value);
            }
        }
    }

    public void addValues(String ... values) {
        this.addValues(Arrays.asList(values));
    }

    public void addValues(NottableString ... values) {
        this.addNottableValues(Arrays.asList(values));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        KeyToMultiValue that = (KeyToMultiValue)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.values, that.values);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = Objects.hash(this.name, this.values);
        }
        return this.hashCode;
    }
}

