/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.util.Objects;
import org.mockserver.file.FileReader;
import org.mockserver.model.Body;

public class XmlSchemaBody
extends Body<String> {
    private int hashCode;
    private final String xmlSchema;

    public XmlSchemaBody(String xmlSchema) {
        super(Body.Type.XML_SCHEMA);
        this.xmlSchema = xmlSchema;
    }

    public static XmlSchemaBody xmlSchema(String xmlSchema) {
        return new XmlSchemaBody(xmlSchema);
    }

    public static XmlSchemaBody xmlSchemaFromResource(String xmlSchemaPath) {
        return new XmlSchemaBody(FileReader.readFileFromClassPathOrPath(xmlSchemaPath));
    }

    @Override
    public String getValue() {
        return this.xmlSchema;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        XmlSchemaBody that = (XmlSchemaBody)o;
        return Objects.equals(this.xmlSchema, that.xmlSchema);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(super.hashCode(), this.xmlSchema);
        }
        return this.hashCode;
    }
}

