/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.openapi;

import com.fasterxml.jackson.databind.ObjectWriter;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.parser.OpenAPIResolver;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.extensions.SwaggerParserExtension;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.util.ResolverFully;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.OpenAPIDefinition;
import org.mockserver.openapi.examples.JsonNodeExampleSerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.slf4j.event.Level;

public class OpenAPISerialiser {
    public static final String OPEN_API_LOAD_ERROR = "Unable to load API spec from provided URL or payload";
    private static final ObjectWriter OBJECT_WRITER = ObjectMapperFactory.createObjectMapper(new JsonNodeExampleSerializer()).writerWithDefaultPrettyPrinter();
    private final MockServerLogger mockServerLogger;

    public OpenAPISerialiser(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    public String asString(OpenAPIDefinition openAPIDefinition) {
        try {
            if (StringUtils.isBlank((CharSequence)openAPIDefinition.getOperationId())) {
                return OBJECT_WRITER.writeValueAsString((Object)this.buildOpenAPI(openAPIDefinition.getSpecUrlOrPayload(), false));
            }
            Optional<Pair<String, Operation>> operation = this.retrieveOperation(openAPIDefinition.getSpecUrlOrPayload(), openAPIDefinition.getOperationId());
            if (operation.isPresent()) {
                return (String)operation.get().getLeft() + ": " + OBJECT_WRITER.writeValueAsString(operation.get().getRight());
            }
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serialising specification for OpenAPIDefinition{}").setArguments(openAPIDefinition).setThrowable(throwable));
        }
        return "";
    }

    public Optional<Pair<String, Operation>> retrieveOperation(String specUrlOrPayload, String operationId) {
        return this.buildOpenAPI(specUrlOrPayload, true).getPaths().values().stream().flatMap(pathItem -> this.mapOperations((PathItem)pathItem).stream()).filter(operation -> StringUtils.isBlank((CharSequence)operationId) || ((Operation)operation.getRight()).getOperationId().equals(operationId)).findFirst();
    }

    public Map<String, List<Pair<String, Operation>>> retrieveOperations(OpenAPI openAPI, String operationId) {
        LinkedHashMap<String, List<Pair<String, Operation>>> operations = new LinkedHashMap<String, List<Pair<String, Operation>>>();
        if (openAPI != null) {
            openAPI.getPaths().forEach((key, value) -> {
                List filteredOperations;
                if (key != null && value != null && !(filteredOperations = this.mapOperations((PathItem)value).stream().filter(operation -> StringUtils.isBlank((CharSequence)operationId) || operationId.equals(((Operation)operation.getRight()).getOperationId())).sorted(Comparator.comparing(Pair::getLeft)).collect(Collectors.toList())).isEmpty()) {
                    operations.put((String)key, filteredOperations);
                }
            });
        }
        return operations;
    }

    private List<Pair<String, Operation>> mapOperations(PathItem pathItem) {
        ArrayList<Pair<String, Operation>> allOperations = new ArrayList<Pair<String, Operation>>();
        if (pathItem.getGet() != null) {
            allOperations.add((Pair<String, Operation>)new ImmutablePair((Object)"GET", (Object)pathItem.getGet()));
        }
        if (pathItem.getPut() != null) {
            allOperations.add((Pair<String, Operation>)new ImmutablePair((Object)"PUT", (Object)pathItem.getPut()));
        }
        if (pathItem.getPost() != null) {
            allOperations.add((Pair<String, Operation>)new ImmutablePair((Object)"POST", (Object)pathItem.getPost()));
        }
        if (pathItem.getPatch() != null) {
            allOperations.add((Pair<String, Operation>)new ImmutablePair((Object)"PATCH", (Object)pathItem.getPatch()));
        }
        if (pathItem.getDelete() != null) {
            allOperations.add((Pair<String, Operation>)new ImmutablePair((Object)"DELETE", (Object)pathItem.getDelete()));
        }
        if (pathItem.getHead() != null) {
            allOperations.add((Pair<String, Operation>)new ImmutablePair((Object)"HEAD", (Object)pathItem.getHead()));
        }
        if (pathItem.getOptions() != null) {
            allOperations.add((Pair<String, Operation>)new ImmutablePair((Object)"OPTIONS", (Object)pathItem.getOptions()));
        }
        if (pathItem.getTrace() != null) {
            allOperations.add((Pair<String, Operation>)new ImmutablePair((Object)"TRACE", (Object)pathItem.getTrace()));
        }
        return allOperations;
    }

    public OpenAPI buildOpenAPI(String specUrlOrPayload, boolean resolve) {
        OpenAPI openAPI = null;
        SwaggerParseResult swaggerParseResult = null;
        List auths = null;
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setResolve(true);
        parseOptions.setResolveFully(true);
        parseOptions.setResolveCombinators(true);
        parseOptions.setFlatten(true);
        parseOptions.setFlattenComposedSchemas(true);
        try {
            if (specUrlOrPayload.endsWith(".json") || specUrlOrPayload.endsWith(".yaml")) {
                SwaggerParserExtension extension;
                specUrlOrPayload = specUrlOrPayload.replaceAll("\\\\", "/");
                List parserExtensions = OpenAPIV3Parser.getExtensions();
                Iterator iterator = parserExtensions.iterator();
                while (iterator.hasNext() && (openAPI = (swaggerParseResult = (extension = (SwaggerParserExtension)iterator.next()).readLocation(specUrlOrPayload, auths, parseOptions)).getOpenAPI()) == null) {
                }
            } else {
                swaggerParseResult = new OpenAPIV3Parser().readContents(specUrlOrPayload, auths, parseOptions);
                openAPI = swaggerParseResult.getOpenAPI();
            }
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(OPEN_API_LOAD_ERROR + (StringUtils.isNotBlank((CharSequence)throwable.getMessage()) ? ", " + throwable.getMessage() : ""), throwable);
        }
        if (openAPI != null) {
            if (resolve) {
                try {
                    return this.resolve(openAPI, auths, specUrlOrPayload);
                }
                catch (Throwable throwable) {
                    throw new IllegalArgumentException(OPEN_API_LOAD_ERROR + (StringUtils.isNotBlank((CharSequence)throwable.getMessage()) ? ", " + throwable.getMessage() : ""), throwable);
                }
            }
            return openAPI;
        }
        if (swaggerParseResult != null) {
            String message = swaggerParseResult.getMessages().stream().filter(Objects::nonNull).collect(Collectors.joining(" and ")).trim();
            throw new IllegalArgumentException(OPEN_API_LOAD_ERROR + (StringUtils.isNotBlank((CharSequence)message) ? ", " + message : ""));
        }
        throw new IllegalArgumentException(OPEN_API_LOAD_ERROR);
    }

    private OpenAPI resolve(OpenAPI openAPI, List<AuthorizationValue> auths, String specUrlOrPayload) {
        if (openAPI != null) {
            OpenAPIResolver.Settings settings = new OpenAPIResolver.Settings();
            settings.addParametersToEachOperation(true);
            openAPI = new OpenAPIResolver(openAPI, auths, specUrlOrPayload, settings).resolve();
            new ResolverFully().resolveFully(openAPI);
        }
        return openAPI;
    }
}

