/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.PortBinding;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.slf4j.event.Level;

public class PortBindingSerializer
implements Serializer<PortBinding> {
    private final MockServerLogger mockServerLogger;
    private ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, new JsonSerializer[0]);
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();

    public PortBindingSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    @Override
    public String serialize(PortBinding portBinding) {
        try {
            return this.objectWriter.writeValueAsString((Object)portBinding);
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serializing portBinding to JSON with value " + portBinding).setThrowable(throwable));
            throw new RuntimeException("Exception while serializing portBinding to JSON with value " + portBinding, throwable);
        }
    }

    @Override
    public PortBinding deserialize(String jsonPortBinding) {
        PortBinding portBinding = null;
        if (jsonPortBinding != null && !jsonPortBinding.isEmpty()) {
            try {
                portBinding = (PortBinding)this.objectMapper.readValue(jsonPortBinding, PortBinding.class);
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while parsing{}for PortBinding " + throwable.getMessage()).setArguments(jsonPortBinding).setThrowable(throwable));
                throw new RuntimeException("exception while parsing PortBinding for [" + jsonPortBinding + "]", throwable);
            }
        }
        return portBinding;
    }

    @Override
    public Class<PortBinding> supportsType() {
        return PortBinding.class;
    }
}

