/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpRequestAndHttpResponse;
import org.mockserver.model.HttpResponse;
import org.mockserver.serialization.HttpRequestAndHttpResponseSerializer;
import org.mockserver.serialization.HttpRequestSerializer;
import org.mockserver.serialization.HttpResponseSerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.mockserver.serialization.model.WebSocketMessageDTO;

public class WebSocketMessageSerializer {
    private ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, new JsonSerializer[0]);
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private Map<Class, Serializer> serializers;

    public WebSocketMessageSerializer(MockServerLogger mockServerLogger) {
        this.serializers = ImmutableMap.of(HttpRequest.class, (Object)new HttpRequestSerializer(mockServerLogger), HttpResponse.class, (Object)new HttpResponseSerializer(mockServerLogger), HttpRequestAndHttpResponse.class, (Object)new HttpRequestAndHttpResponseSerializer(mockServerLogger));
    }

    public String serialize(Object message) throws JsonProcessingException {
        if (this.serializers.containsKey(message.getClass())) {
            WebSocketMessageDTO value = new WebSocketMessageDTO().setType(message.getClass().getName()).setValue(this.serializers.get(message.getClass()).serialize(message));
            return this.objectWriter.writeValueAsString((Object)value);
        }
        return this.objectWriter.writeValueAsString((Object)new WebSocketMessageDTO().setType(message.getClass().getName()).setValue(this.objectMapper.writeValueAsString(message)));
    }

    public Object deserialize(String messageJson) throws ClassNotFoundException, IOException {
        WebSocketMessageDTO webSocketMessageDTO = (WebSocketMessageDTO)this.objectMapper.readValue(messageJson, WebSocketMessageDTO.class);
        if (webSocketMessageDTO.getType() != null && webSocketMessageDTO.getValue() != null) {
            Class<?> format = Class.forName(webSocketMessageDTO.getType());
            if (this.serializers.containsKey(format)) {
                return this.serializers.get(format).deserialize(webSocketMessageDTO.getValue());
            }
            return this.objectMapper.readValue(webSocketMessageDTO.getValue(), format);
        }
        return null;
    }
}

