/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import org.mockserver.model.Delay;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.serialization.model.DTO;
import org.mockserver.serialization.model.DelayDTO;

public class HttpClassCallbackDTO
extends ObjectWithReflectiveEqualsHashCodeToString
implements DTO<HttpClassCallback> {
    private String callbackClass;
    private DelayDTO delay;

    public HttpClassCallbackDTO(HttpClassCallback httpClassCallback) {
        if (httpClassCallback != null) {
            this.callbackClass = httpClassCallback.getCallbackClass();
            if (httpClassCallback.getDelay() != null) {
                this.delay = new DelayDTO(httpClassCallback.getDelay());
            }
        }
    }

    public HttpClassCallbackDTO() {
    }

    @Override
    public HttpClassCallback buildObject() {
        Delay delay = null;
        if (this.delay != null) {
            delay = this.delay.buildObject();
        }
        return (HttpClassCallback)new HttpClassCallback().withCallbackClass(this.callbackClass).withDelay(delay);
    }

    public String getCallbackClass() {
        return this.callbackClass;
    }

    public HttpClassCallbackDTO setCallbackClass(String callbackClass) {
        this.callbackClass = callbackClass;
        return this;
    }

    public DelayDTO getDelay() {
        return this.delay;
    }

    public void setDelay(DelayDTO delay) {
        this.delay = delay;
    }
}

