/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket.tls;

import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.KeyAndCertificateFactory;
import org.mockserver.socket.tls.KeyAndCertificateFactoryFactory;
import org.slf4j.event.Level;

public class KeyStoreFactory {
    public static final String KEY_STORE_TYPE = "jks";
    public static final String KEY_STORE_PASSWORD = "changeit";
    public static final String KEY_STORE_CERT_ALIAS = "mockserver-client-cert";
    public static final String KEY_STORE_CA_ALIAS = "mockserver-ca-cert";
    public final String keyStoreFileName = "mockserver_keystore_" + UUID.randomUUID().toString() + "_" + "jks";
    private static final String SSL_CONTEXT_PROTOCOL = "TLSv1.2";
    private static final String SSL_CONTEXT_FALLBACK_PROTOCOL = "TLSv1";
    private SSLContext sslContext;
    private final MockServerLogger mockServerLogger;
    private final KeyAndCertificateFactory keyAndCertificateFactory;

    public KeyStoreFactory(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.keyAndCertificateFactory = KeyAndCertificateFactoryFactory.createKeyAndCertificateFactory(mockServerLogger);
    }

    public synchronized SSLContext sslContext() {
        if (this.keyAndCertificateFactory.certificateNotYetCreated()) {
            this.keyAndCertificateFactory.buildAndSavePrivateKeyAndX509Certificate();
        }
        return this.sslContext(this.keyAndCertificateFactory.privateKey(), this.keyAndCertificateFactory.x509Certificate(), this.keyAndCertificateFactory.certificateAuthorityX509Certificate(), new X509Certificate[]{this.keyAndCertificateFactory.certificateAuthorityX509Certificate()});
    }

    public synchronized SSLContext sslContext(PrivateKey privateKey, X509Certificate x509Certificate, X509Certificate certificateAuthorityX509Certificate, X509Certificate[] trustX509CertificateChain) {
        if (this.sslContext == null || ConfigurationProperties.rebuildTLSContext()) {
            try {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(this.loadOrCreateKeyStore(privateKey, x509Certificate, certificateAuthorityX509Certificate, trustX509CertificateChain), KEY_STORE_PASSWORD.toCharArray());
                this.sslContext = this.getSSLContextInstance();
                this.sslContext.init(keyManagerFactory.getKeyManagers(), InsecureTrustManagerFactory.INSTANCE.getTrustManagers(), null);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Failed to initialize the SSLContext", throwable);
            }
        }
        return this.sslContext;
    }

    public KeyStore loadOrCreateKeyStore() {
        if (this.keyAndCertificateFactory.certificateNotYetCreated()) {
            this.keyAndCertificateFactory.buildAndSavePrivateKeyAndX509Certificate();
        }
        return this.loadOrCreateKeyStore(this.keyAndCertificateFactory.privateKey(), this.keyAndCertificateFactory.x509Certificate(), this.keyAndCertificateFactory.certificateAuthorityX509Certificate(), new X509Certificate[]{this.keyAndCertificateFactory.certificateAuthorityX509Certificate()});
    }

    public KeyStore loadOrCreateKeyStore(PrivateKey privateKey, X509Certificate x509Certificate, X509Certificate certificateAuthorityX509Certificate, X509Certificate[] trustX509CertificateChain) {
        KeyStore keystore = null;
        File keyStoreFile = new File(this.keyStoreFileName);
        if (keyStoreFile.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(keyStoreFile);){
                keystore = KeyStore.getInstance(KEY_STORE_TYPE);
                keystore.load(fileInputStream, KEY_STORE_PASSWORD.toCharArray());
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while loading KeyStore from " + keyStoreFile.getAbsolutePath(), e);
            }
        }
        System.setProperty("javax.net.ssl.trustStore", keyStoreFile.getAbsolutePath());
        return this.savePrivateKeyAndX509InKeyStore(keystore, privateKey, KEY_STORE_PASSWORD.toCharArray(), new X509Certificate[]{x509Certificate, certificateAuthorityX509Certificate}, trustX509CertificateChain);
    }

    private SSLContext getSSLContextInstance() throws NoSuchAlgorithmException {
        try {
            if (MockServerLogger.isEnabled(Level.DEBUG)) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.DEBUG).setMessageFormat("using protocol{}").setArguments(SSL_CONTEXT_PROTOCOL));
            }
            return SSLContext.getInstance(SSL_CONTEXT_PROTOCOL);
        }
        catch (NoSuchAlgorithmException nsae) {
            if (MockServerLogger.isEnabled(Level.WARN)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("protocol{}not available, falling back to{}").setArguments(SSL_CONTEXT_PROTOCOL, SSL_CONTEXT_FALLBACK_PROTOCOL).setThrowable(nsae));
            }
            return SSLContext.getInstance(SSL_CONTEXT_FALLBACK_PROTOCOL);
        }
    }

    private KeyStore savePrivateKeyAndX509InKeyStore(KeyStore existingKeyStore, Key privateKey, char[] keyStorePassword, Certificate[] chain, X509Certificate ... caCerts) {
        try {
            KeyStore keyStore = existingKeyStore;
            if (keyStore == null) {
                keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
                keyStore.load(null, keyStorePassword);
            }
            try {
                keyStore.deleteEntry(KEY_STORE_CERT_ALIAS);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            keyStore.setKeyEntry(KEY_STORE_CERT_ALIAS, privateKey, keyStorePassword, chain);
            for (X509Certificate caCert : caCerts) {
                try {
                    keyStore.deleteEntry(KEY_STORE_CA_ALIAS);
                }
                catch (KeyStoreException keyStoreException) {
                    // empty catch block
                }
                keyStore.setCertificateEntry(KEY_STORE_CA_ALIAS, caCert);
            }
            String keyStoreFileAbsolutePath = new File(this.keyStoreFileName).getAbsolutePath();
            try (FileOutputStream fileOutputStream = new FileOutputStream(keyStoreFileAbsolutePath);){
                keyStore.store(fileOutputStream, keyStorePassword);
                if (MockServerLogger.isEnabled(Level.TRACE)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("saving key store to file [" + keyStoreFileAbsolutePath + "]"));
                }
            }
            new File(keyStoreFileAbsolutePath).deleteOnExit();
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while saving KeyStore", e);
        }
    }
}

