/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket.tls.jdk;

import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collector;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.PEMToFile;
import org.mockserver.socket.tls.jdk.CertificateSigningRequest;
import org.mockserver.socket.tls.jdk.X509AndPrivateKey;
import org.slf4j.event.Level;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.DNSName;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.IPAddressName;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class X509Generator {
    private final MockServerLogger mockServerLogger;

    public X509Generator(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    public X509AndPrivateKey generateRootX509AndPrivateKey(CertificateSigningRequest csr) throws IOException, NoSuchAlgorithmException, CertificateException, InvalidKeyException, NoSuchProviderException, SignatureException {
        KeyPair keyPair = this.generateKeyPair(csr.getKeyPairAlgorithm(), csr.getKeyPairSize());
        X500Name subjectAndIssuer = new X500Name(CertificateSigningRequest.buildDistinguishedName(csr.getCommonName()));
        X509CertInfo x509CertInfo = this.buildX509CertInfo(subjectAndIssuer, subjectAndIssuer, keyPair.getPublic(), csr);
        this.updateWithRootCertificateExtensions(x509CertInfo, keyPair.getPublic());
        return this.signX509KeyPair(keyPair.getPrivate(), keyPair, x509CertInfo, csr.getSigningAlgorithm());
    }

    public X509AndPrivateKey generateLeafX509AndPrivateKey(CertificateSigningRequest csr, String issuerDistinguishingName, String caPrivateKey, X509Certificate caCertificate) throws IOException, NoSuchAlgorithmException, CertificateException, InvalidKeyException, NoSuchProviderException, SignatureException, InvalidKeySpecException {
        PrivateKey privateKey = KeyFactory.getInstance(csr.getKeyPairAlgorithm()).generatePrivate(PEMToFile.keySpecFromPEM(caPrivateKey));
        KeyPair keyPair = this.generateKeyPair(csr.getKeyPairAlgorithm(), csr.getKeyPairSize());
        X500Name subject = new X500Name(CertificateSigningRequest.buildDistinguishedName(csr.getCommonName()));
        X500Name issuer = new X500Name(issuerDistinguishingName);
        X509CertInfo x509CertInfo = this.buildX509CertInfo(subject, issuer, keyPair.getPublic(), csr);
        this.updateWithCertificateExtensions(x509CertInfo, keyPair.getPublic(), caCertificate.getPublicKey(), csr.getSubjectAlternativeNames());
        X509AndPrivateKey x509AndPrivateKey = this.signX509KeyPair(privateKey, keyPair, x509CertInfo, csr.getSigningAlgorithm());
        X509Certificate signedX509Certificate = PEMToFile.x509FromPEM(x509AndPrivateKey.getCert());
        signedX509Certificate.checkValidity(new Date());
        signedX509Certificate.verify(caCertificate.getPublicKey());
        return x509AndPrivateKey;
    }

    private KeyPair generateKeyPair(String algorithm, int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(algorithm);
        kpg.initialize(keySize);
        return kpg.genKeyPair();
    }

    private X509CertInfo buildX509CertInfo(X500Name subject, X500Name issuer, PublicKey publicKey, CertificateSigningRequest csr) throws IOException, NoSuchAlgorithmException, CertificateException {
        X509CertInfo x509CertInfo = new X509CertInfo();
        CertificateValidity interval = new CertificateValidity(CertificateSigningRequest.NOT_BEFORE, CertificateSigningRequest.NOT_AFTER);
        BigInteger sn = new BigInteger(64, new Random());
        x509CertInfo.set("validity", interval);
        x509CertInfo.set("serialNumber", new CertificateSerialNumber(sn));
        x509CertInfo.set("subject", subject);
        x509CertInfo.set("issuer", issuer);
        x509CertInfo.set("key", new CertificateX509Key(publicKey));
        x509CertInfo.set("version", new CertificateVersion(2));
        AlgorithmId algo = new AlgorithmId(AlgorithmId.get(csr.getSigningAlgorithm()).getOID());
        x509CertInfo.set("algorithmID", new CertificateAlgorithmId(algo));
        return x509CertInfo;
    }

    private void updateWithCertificateExtensions(X509CertInfo x509CertInfo, PublicKey publicKey, PublicKey caPublicKey, List<String> subjectAlternativeNames) throws IOException, CertificateException {
        CertificateExtensions certificateExtensions = new CertificateExtensions();
        GeneralNames generalNames = subjectAlternativeNames.stream().filter(StringUtils::isNotBlank).map(this::buildGeneralName).filter(Objects::nonNull).collect(Collector.of(GeneralNames::new, GeneralNames::add, (generalNames1, generalNames2) -> null, new Collector.Characteristics[0]));
        if (!generalNames.isEmpty()) {
            certificateExtensions.set("SubjectAlternativeName", new SubjectAlternativeNameExtension(Boolean.FALSE, generalNames));
        }
        certificateExtensions.set("SubjectKeyIdentifier", new SubjectKeyIdentifierExtension(new KeyIdentifier(publicKey).getIdentifier()));
        certificateExtensions.set("AuthorityKeyIdentifier", new AuthorityKeyIdentifierExtension(new KeyIdentifier(caPublicKey), null, null));
        x509CertInfo.set("extensions", certificateExtensions);
    }

    private void updateWithRootCertificateExtensions(X509CertInfo x509CertInfo, PublicKey publicKey) throws IOException, CertificateException {
        CertificateExtensions certificateExtensions = new CertificateExtensions();
        certificateExtensions.set("BasicConstraints", new BasicConstraintsExtension(true, true, -1));
        boolean[] keyUsage = new boolean[9];
        keyUsage[5] = true;
        certificateExtensions.set("KeyUsage", new KeyUsageExtension(keyUsage));
        certificateExtensions.set("SubjectKeyIdentifier", new SubjectKeyIdentifierExtension(new KeyIdentifier(publicKey).getIdentifier()));
        x509CertInfo.set("extensions", certificateExtensions);
    }

    private GeneralName buildGeneralName(String subjectAlternativeName) {
        if (InetAddresses.isUriInetAddress((String)subjectAlternativeName)) {
            try {
                return new GeneralName(new IPAddressName(subjectAlternativeName));
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("unable to use ip address with the value \"" + subjectAlternativeName + "\" as Subject Alternative Name (SAN) for X509 as JDK does not support SANs with that format").setThrowable(throwable));
            }
        } else if (InternetDomainName.isValid((String)subjectAlternativeName)) {
            try {
                return new GeneralName(new DNSName(subjectAlternativeName));
            }
            catch (Throwable ignore) {
                try {
                    return new GeneralName(new DNSName(new DerValue(22, subjectAlternativeName)));
                }
                catch (Throwable throwable) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("unable to use domain name with the value \"" + subjectAlternativeName + "\" as Subject Alternative Name (SAN) for X509 as JDK does not support SANs with that format").setThrowable(throwable));
                }
            }
        } else if (subjectAlternativeName.contains("*")) {
            try {
                return new GeneralName(new DNSName(new DerValue(22, subjectAlternativeName)));
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("unable to use domain name with the value \"" + subjectAlternativeName + "\" as Subject Alternative Name (SAN) for X509 as JDK does not support SANs with that format").setThrowable(throwable));
            }
        }
        return null;
    }

    private X509AndPrivateKey signX509KeyPair(PrivateKey privateKey, KeyPair keyPair, X509CertInfo x509CertInfo, String signatureAlgorithm) throws CertificateException, NoSuchAlgorithmException, IOException, InvalidKeyException, NoSuchProviderException, SignatureException {
        x509CertInfo.set("algorithmID", new CertificateAlgorithmId(AlgorithmId.get(signatureAlgorithm)));
        X509CertImpl cert = new X509CertImpl(x509CertInfo);
        cert.sign(privateKey, signatureAlgorithm);
        return new X509AndPrivateKey().setPrivateKey(PEMToFile.privateKeyToPEM(keyPair.getPrivate().getEncoded())).setCert(PEMToFile.certToPEM(new byte[][]{cert.getEncoded()}));
    }
}

