/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.validator.jsonschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.main.JsonValidator;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.file.FileReader;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.validator.Validator;
import org.slf4j.event.Level;

public class JsonSchemaValidator
extends ObjectWithReflectiveEqualsHashCodeToString
implements Validator<String> {
    public static final String OPEN_API_SPECIFICATION_URL = "See: https://app.swaggerhub.com/apis/jamesdbloom/mock-server-openapi/5.11.x for OpenAPI Specification";
    private static final Map<String, String> schemaCache = new ConcurrentHashMap<String, String>();
    private final MockServerLogger mockServerLogger;
    private final String schema;
    private final JsonNode schemaJsonNode;
    private final String mainSchemeFile;
    private final JsonValidator validator = JsonSchemaFactory.byDefault().getValidator();
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.createObjectMapper();

    public JsonSchemaValidator(MockServerLogger mockServerLogger, String schema) {
        this.mockServerLogger = mockServerLogger;
        if (schema.trim().endsWith(".json")) {
            this.schema = FileReader.readFileFromClassPathOrPath(schema);
        } else if (schema.trim().endsWith("}")) {
            this.schema = schema;
        } else {
            throw new IllegalArgumentException("Schema must either be a path reference to a *.json file or a json string");
        }
        this.mainSchemeFile = null;
        this.schemaJsonNode = this.getSchemaJsonNode();
    }

    public JsonSchemaValidator(MockServerLogger mockServerLogger, String routePath, String mainSchemeFile, String ... referenceFiles) {
        this.mockServerLogger = mockServerLogger;
        if (!schemaCache.containsKey(mainSchemeFile)) {
            schemaCache.put(mainSchemeFile, this.addReferencesIntoSchema(routePath, mainSchemeFile, referenceFiles));
        }
        this.schema = schemaCache.get(mainSchemeFile);
        this.mainSchemeFile = mainSchemeFile;
        this.schemaJsonNode = this.getSchemaJsonNode();
    }

    private JsonNode getSchemaJsonNode() {
        try {
            return OBJECT_MAPPER.readTree(this.schema);
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception loading JSON Schema " + throwable.getMessage()).setThrowable(throwable));
            return null;
        }
    }

    public String getSchema() {
        return this.schema;
    }

    private String addReferencesIntoSchema(String routePath, String mainSchemeFile, String ... referenceFiles) {
        String combinedSchema = "";
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
            JsonNode jsonSchema = objectMapper.readTree(FileReader.readFileFromClassPathOrPath(routePath + mainSchemeFile + ".json"));
            JsonNode definitions = jsonSchema.get("definitions");
            if (definitions instanceof ObjectNode) {
                for (String definitionName : referenceFiles) {
                    ((ObjectNode)definitions).set(definitionName, objectMapper.readTree(FileReader.readFileFromClassPathOrPath(routePath + definitionName + ".json")));
                }
            }
            combinedSchema = ObjectMapperFactory.createObjectMapper(true, new JsonSerializer[0]).writeValueAsString((Object)jsonSchema);
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception loading JSON Schema " + throwable.getMessage()).setThrowable(throwable));
        }
        return combinedSchema;
    }

    @Override
    public String isValid(String json) {
        return this.isValid(json, true);
    }

    public String isValid(String json, boolean addOpenAPISpecificationMessage) {
        String validationResult = "";
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                ProcessingReport processingReport = this.validator.validate(this.schemaJsonNode, OBJECT_MAPPER.readTree(json), true);
                if (!processingReport.isSuccess()) {
                    validationResult = this.formatProcessingReport(processingReport, addOpenAPISpecificationMessage);
                }
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception validating JSON").setThrowable(throwable));
                return throwable.getClass().getSimpleName() + " - " + throwable.getMessage();
            }
        }
        return validationResult;
    }

    private String formatProcessingReport(ProcessingReport processingMessages, boolean addOpenAPISpecificationMessage) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        for (ProcessingMessage processingMessage : processingMessages) {
            JsonNode processingMessageJson = processingMessage.asJson();
            JsonNode instanceJson = processingMessageJson.get("instance");
            JsonNode schemaJson = processingMessageJson.get("schema");
            JsonNode reports = processingMessageJson.get("reports");
            String fieldPointer = this.pointerValue(instanceJson).replaceAll("\"", "");
            String schemaPointer = this.removeDefinitionPrefix(this.pointerValue(schemaJson));
            if (this.isErrorForField(reports, fieldPointer, "/headers")) {
                validationErrors.add("field: \"" + this.deepFieldName(reports, fieldPointer, "/headers") + (StringUtils.isNotBlank((CharSequence)schemaPointer) ? "\" for schema: \"" + schemaPointer : "") + "\" has error: \" only one of the following example formats is allowed: " + Character.NEW_LINE + Character.NEW_LINE + "   {" + Character.NEW_LINE + "       \"exampleRegexHeader\": [" + Character.NEW_LINE + "           \"^some +regex$\"" + Character.NEW_LINE + "       ], " + Character.NEW_LINE + "       \"exampleNottedAndSimpleStringHeader\": [" + Character.NEW_LINE + "           \"!notThisValue\", " + Character.NEW_LINE + "           \"simpleStringMatch\"" + Character.NEW_LINE + "       ]" + Character.NEW_LINE + "   }" + Character.NEW_LINE + Character.NEW_LINE + "or:" + Character.NEW_LINE + Character.NEW_LINE + "   {" + Character.NEW_LINE + "       \"exampleSchemaHeader\": [" + Character.NEW_LINE + "           {" + Character.NEW_LINE + "               \"type\": \"number\"" + Character.NEW_LINE + "           }" + Character.NEW_LINE + "       ], " + Character.NEW_LINE + "       \"exampleMultiSchemaHeader\": [" + Character.NEW_LINE + "           {" + Character.NEW_LINE + "               \"type\": \"string\", " + Character.NEW_LINE + "               \"pattern\": \"^some +regex$\"" + Character.NEW_LINE + "           }, " + Character.NEW_LINE + "           {" + Character.NEW_LINE + "               \"type\": \"string\", " + Character.NEW_LINE + "               \"format\": \"ipv4\"" + Character.NEW_LINE + "           }" + Character.NEW_LINE + "       ]" + Character.NEW_LINE + "   }" + Character.NEW_LINE);
            }
            if (this.isErrorForField(reports, fieldPointer, "/pathParameters")) {
                validationErrors.add("field: \"" + this.deepFieldName(reports, fieldPointer, "/pathParameters") + (StringUtils.isNotBlank((CharSequence)schemaPointer) ? "\" for schema: \"" + schemaPointer : "") + "\" has error: \" only one of the following example formats is allowed: " + Character.NEW_LINE + Character.NEW_LINE + "   {" + Character.NEW_LINE + "       \"exampleRegexParameter\": [" + Character.NEW_LINE + "           \"^some +regex$\"" + Character.NEW_LINE + "       ], " + Character.NEW_LINE + "       \"exampleNottedAndSimpleStringParameter\": [" + Character.NEW_LINE + "           \"!notThisValue\", " + Character.NEW_LINE + "           \"simpleStringMatch\"" + Character.NEW_LINE + "       ]" + Character.NEW_LINE + "   }" + Character.NEW_LINE + Character.NEW_LINE + "or:" + Character.NEW_LINE + Character.NEW_LINE + "   {" + Character.NEW_LINE + "       \"exampleSchemaParameter\": [" + Character.NEW_LINE + "           {" + Character.NEW_LINE + "               \"type\": \"number\"" + Character.NEW_LINE + "           }" + Character.NEW_LINE + "       ], " + Character.NEW_LINE + "       \"exampleMultiSchemaParameter\": [" + Character.NEW_LINE + "           {" + Character.NEW_LINE + "               \"type\": \"string\", " + Character.NEW_LINE + "               \"pattern\": \"^some +regex$\"" + Character.NEW_LINE + "           }, " + Character.NEW_LINE + "           {" + Character.NEW_LINE + "               \"type\": \"string\", " + Character.NEW_LINE + "               \"format\": \"ipv4\"" + Character.NEW_LINE + "           }" + Character.NEW_LINE + "       ]" + Character.NEW_LINE + "   }" + Character.NEW_LINE);
            }
            if (this.isErrorForField(reports, fieldPointer, "/queryStringParameters")) {
                validationErrors.add("field: \"" + this.deepFieldName(reports, fieldPointer, "/queryStringParameters") + (StringUtils.isNotBlank((CharSequence)schemaPointer) ? "\" for schema: \"" + schemaPointer : "") + "\" has error: \" only one of the following example formats is allowed: " + Character.NEW_LINE + Character.NEW_LINE + "   {" + Character.NEW_LINE + "       \"exampleRegexParameter\": [" + Character.NEW_LINE + "           \"^some +regex$\"" + Character.NEW_LINE + "       ], " + Character.NEW_LINE + "       \"exampleNottedAndSimpleStringParameter\": [" + Character.NEW_LINE + "           \"!notThisValue\", " + Character.NEW_LINE + "           \"simpleStringMatch\"" + Character.NEW_LINE + "       ]" + Character.NEW_LINE + "   }" + Character.NEW_LINE + Character.NEW_LINE + "or:" + Character.NEW_LINE + Character.NEW_LINE + "   {" + Character.NEW_LINE + "       \"exampleSchemaParameter\": [" + Character.NEW_LINE + "           {" + Character.NEW_LINE + "               \"type\": \"number\"" + Character.NEW_LINE + "           }" + Character.NEW_LINE + "       ], " + Character.NEW_LINE + "       \"exampleMultiSchemaParameter\": [" + Character.NEW_LINE + "           {" + Character.NEW_LINE + "               \"type\": \"string\", " + Character.NEW_LINE + "               \"pattern\": \"^some +regex$\"" + Character.NEW_LINE + "           }, " + Character.NEW_LINE + "           {" + Character.NEW_LINE + "               \"type\": \"string\", " + Character.NEW_LINE + "               \"format\": \"ipv4\"" + Character.NEW_LINE + "           }" + Character.NEW_LINE + "       ]" + Character.NEW_LINE + "   }" + Character.NEW_LINE);
            }
            if (this.isErrorForField(reports, fieldPointer, "/cookies")) {
                validationErrors.add("field: \"" + this.deepFieldName(reports, fieldPointer, "/cookies") + (StringUtils.isNotBlank((CharSequence)schemaPointer) ? "\" for schema: \"" + schemaPointer : "") + "\" has error: \" only one of the following example formats is allowed: " + Character.NEW_LINE + Character.NEW_LINE + "   {" + Character.NEW_LINE + "       \"exampleRegexCookie\": \"^some +regex$\", " + Character.NEW_LINE + "       \"exampleNottedRegexCookie\": \"!notThisValue\", " + Character.NEW_LINE + "       \"exampleSimpleStringCookie\": \"simpleStringMatch\"" + Character.NEW_LINE + "   }" + Character.NEW_LINE + Character.NEW_LINE + "or:" + Character.NEW_LINE + Character.NEW_LINE + "   {" + Character.NEW_LINE + "       \"exampleNumberSchemaCookie\": {" + Character.NEW_LINE + "           \"type\": \"number\"" + Character.NEW_LINE + "       }, " + Character.NEW_LINE + "       \"examplePatternSchemaCookie\": {" + Character.NEW_LINE + "           \"type\": \"string\", " + Character.NEW_LINE + "           \"pattern\": \"^some +regex$\"" + Character.NEW_LINE + "       }, " + Character.NEW_LINE + "       \"exampleFormatSchemaCookie\": {" + Character.NEW_LINE + "           \"type\": \"string\", " + Character.NEW_LINE + "           \"format\": \"ipv4\"" + Character.NEW_LINE + "       }" + Character.NEW_LINE + "   }" + Character.NEW_LINE);
            }
            if (this.isErrorForField(reports, fieldPointer, "/body") && !schemaPointer.contains("bodyWithContentType")) {
                validationErrors.add("field: \"" + this.deepFieldName(reports, fieldPointer, "/body") + (StringUtils.isNotBlank((CharSequence)schemaPointer) ? "\" for schema: \"" + schemaPointer : "") + "\" has error: \" a plain string, JSON object or one of the following example bodies must be specified " + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"BINARY\"," + Character.NEW_LINE + "     \"base64Bytes\": \"\"," + Character.NEW_LINE + "     \"contentType\": \"\"" + Character.NEW_LINE + "   }, " + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"JSON\"," + Character.NEW_LINE + "     \"json\": \"\"," + Character.NEW_LINE + "     \"contentType\": \"\"," + Character.NEW_LINE + "     \"matchType\": \"ONLY_MATCHING_FIELDS\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"JSON_SCHEMA\"," + Character.NEW_LINE + "     \"jsonSchema\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"JSON_PATH\"," + Character.NEW_LINE + "     \"jsonPath\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"PARAMETERS\"," + Character.NEW_LINE + "     \"parameters\": {\"name\": \"value\"}" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"REGEX\"," + Character.NEW_LINE + "     \"regex\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"STRING\"," + Character.NEW_LINE + "     \"string\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"XML\"," + Character.NEW_LINE + "     \"xml\": \"\"," + Character.NEW_LINE + "     \"contentType\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"XML_SCHEMA\"," + Character.NEW_LINE + "     \"xmlSchema\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"XPATH\"," + Character.NEW_LINE + "     \"xpath\": \"\"" + Character.NEW_LINE + "   }" + Character.NEW_LINE);
            }
            if (this.isErrorForField(reports, fieldPointer, "/body") && schemaPointer.contains("bodyWithContentType")) {
                validationErrors.add("field: \"" + this.deepFieldName(reports, fieldPointer, "/body") + (StringUtils.isNotBlank((CharSequence)schemaPointer) ? "\" for schema: \"" + schemaPointer : "") + "\" has error: \" a plain string, JSON object or one of the following example bodies must be specified " + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"type\": \"BINARY\"," + Character.NEW_LINE + "     \"base64Bytes\": \"\"," + Character.NEW_LINE + "     \"contentType\": \"\"" + Character.NEW_LINE + "   }, " + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"type\": \"JSON\"," + Character.NEW_LINE + "     \"json\": \"\"," + Character.NEW_LINE + "     \"contentType\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"type\": \"PARAMETERS\"," + Character.NEW_LINE + "     \"parameters\": {\"name\": \"value\"}" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"type\": \"STRING\"," + Character.NEW_LINE + "     \"string\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"type\": \"XML\"," + Character.NEW_LINE + "     \"xml\": \"\"," + Character.NEW_LINE + "     \"contentType\": \"\"" + Character.NEW_LINE + "   }" + Character.NEW_LINE);
            }
            if (String.valueOf(processingMessageJson.get("keyword")).contains("oneOf")) {
                StringBuilder oneOfErrorMessage = new StringBuilder("oneOf of the following must be specified ");
                if (fieldPointer.isEmpty() && StringUtils.isNotBlank((CharSequence)this.mainSchemeFile)) {
                    if (this.mainSchemeFile.contains("expectation")) {
                        validationErrors.add(oneOfErrorMessage.append(Arrays.asList("\"httpResponse\"", "\"httpResponseTemplate\"", "\"httpResponseObjectCallback\"", "\"httpResponseClassCallback\"", "\"httpForward\"", "\"httpForwardTemplate\"", "\"httpForwardObjectCallback\"", "\"httpForwardClassCallback\"", "\"httpOverrideForwardedRequest\"", "\"httpError\"")).append(" but found ").append(processingMessageJson.get("matched")).append(" without errors").toString());
                    } else if (this.mainSchemeFile.contains("requestDefinition")) {
                        validationErrors.add(oneOfErrorMessage.append(Arrays.asList("\"httpRequest\"", "\"openAPIDefinition\"")).append(" but found ").append(processingMessageJson.get("matched")).append(" without errors").toString());
                    }
                }
            }
            if (fieldPointer.endsWith("/times") && processingMessage.toString().contains("has properties which are not allowed by the schema") && String.valueOf(schemaJson).contains("verificationTimes")) {
                validationErrors.add("field: \"" + fieldPointer + (StringUtils.isNotBlank((CharSequence)schemaPointer) ? "\" for schema: \"" + schemaPointer : "") + "\" has error: \"" + processingMessage.getMessage() + ", allowed fields are [\"atLeast\", \"atMost\"]\"");
            }
            if (reports != null) {
                validationErrors.addAll(this.extractMessage(reports));
                continue;
            }
            validationErrors.addAll(this.extractMessage(processingMessageJson));
        }
        validationErrors.sort(String::compareToIgnoreCase);
        return validationErrors.size() + " error" + (validationErrors.size() > 1 ? "s" : "") + ":" + Character.NEW_LINE + " - " + Joiner.on((String)(Character.NEW_LINE + " - ")).join(validationErrors) + (addOpenAPISpecificationMessage ? Character.NEW_LINE + Character.NEW_LINE + OPEN_API_SPECIFICATION_URL : "");
    }

    private boolean isErrorForField(JsonNode reports, String fieldPointer, String fieldName) {
        return fieldPointer.endsWith(fieldName) || fieldPointer.contains("/httpRequest") && reports.has("/definitions/requestDefinition/oneOf/0") && JsonSchemaValidator.stream(reports.get("/definitions/requestDefinition/oneOf/0").iterator()).anyMatch(jsonNode -> this.pointerValue(jsonNode.get("instance")).endsWith(fieldName));
    }

    private String deepFieldName(JsonNode reports, String fieldPointer, String fieldName) {
        if (fieldPointer.endsWith(fieldName)) {
            return fieldPointer;
        }
        if (fieldPointer.contains("/httpRequest") && reports.has("/definitions/requestDefinition/oneOf/0") && JsonSchemaValidator.stream(reports.get("/definitions/requestDefinition/oneOf/0").iterator()).anyMatch(jsonNode -> this.pointerValue(jsonNode.get("instance")).endsWith(fieldName))) {
            return JsonSchemaValidator.stream(reports.get("/definitions/requestDefinition/oneOf/0").iterator()).filter(jsonNode -> this.pointerValue(jsonNode.get("instance")).endsWith(fieldName)).findFirst().map(instanceNode -> this.pointerValue(instanceNode.get("instance"))).orElse("");
        }
        return "";
    }

    private String removeDefinitionPrefix(String text) {
        return StringUtils.remove((String)text, (String)"/definitions/");
    }

    private String pointerValue(JsonNode jsonNode) {
        return jsonNode != null && jsonNode.get("pointer") != null && StringUtils.isNotBlank((CharSequence)jsonNode.get("pointer").asText()) ? jsonNode.get("pointer").asText() : "";
    }

    public static <T> Stream<T> stream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    public Set<String> extractMessage(JsonNode reports) {
        HashSet<String> messages = new HashSet<String>();
        if (reports != null) {
            JsonSchemaValidator.stream(reports.fields()).forEach(field -> {
                if ("message".equals(field.getKey())) {
                    String fieldName = this.pointerValue(reports.get("instance"));
                    String schemaName = this.pointerValue(reports.get("schema"));
                    if (field.getValue() != null) {
                        boolean fieldNotBlank = StringUtils.isNotBlank((CharSequence)fieldName);
                        boolean schemaNotBlank = StringUtils.isNotBlank((CharSequence)schemaName);
                        messages.add((fieldNotBlank ? "field: \"" + fieldName + "\"" : "") + (schemaNotBlank ? (fieldNotBlank ? " for " : "") + "schema: \"" + this.removeDefinitionPrefix(schemaName) + "\"" : "") + (fieldNotBlank || schemaNotBlank ? " has error: \"" : "") + ((JsonNode)field.getValue()).asText() + (fieldNotBlank || schemaNotBlank ? "\"" : ""));
                    }
                } else if (field.getValue() != null && (((JsonNode)field.getValue()).isArray() || ((JsonNode)field.getValue()).isObject())) {
                    messages.addAll(this.extractMessage((JsonNode)field.getValue()));
                }
            });
            JsonSchemaValidator.stream(reports.iterator()).forEach(node -> messages.addAll(this.extractMessage((JsonNode)node)));
        }
        return messages;
    }
}

