/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.NotSslRecordException;
import javax.net.ssl.SSLException;
import org.mockserver.client.NettyHttpClient;
import org.mockserver.model.HttpResponse;

@ChannelHandler.Sharable
public class HttpClientHandler
extends SimpleChannelInboundHandler<HttpResponse> {
    public HttpClientHandler() {
        super(false);
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpResponse response) {
        ((SettableFuture)ctx.channel().attr(NettyHttpClient.RESPONSE_FUTURE).get()).set((Object)response);
        ctx.close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.isNotSslException(cause)) {
            cause.printStackTrace();
        }
        ((SettableFuture)ctx.channel().attr(NettyHttpClient.RESPONSE_FUTURE).get()).setException(cause);
        ctx.close();
    }

    private boolean isNotSslException(Throwable cause) {
        return !(cause.getCause() instanceof SSLException) && !(cause instanceof DecoderException | cause instanceof NotSslRecordException);
    }
}

