/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.filters;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.mockserver.model.Header;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpRequest;

public class HopByHopHeaderFilter {
    public HttpRequest onRequest(HttpRequest request) {
        if (request != null) {
            List<String> headersToRemove = Arrays.asList("proxy-connection", "connection", "keep-alive", "transfer-encoding", "te", "trailer", "proxy-authorization", "proxy-authenticate", "upgrade");
            Headers headers = new Headers(new Header[0]);
            for (Header header : request.getHeaderList()) {
                if (headersToRemove.contains(header.getName().getValue().toLowerCase(Locale.ENGLISH))) continue;
                headers.withEntry(header);
            }
            HttpRequest clonedRequest = request.clone();
            if (!headers.isEmpty()) {
                clonedRequest.withHeaders(headers);
            }
            return clonedRequest;
        }
        return null;
    }
}

