/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.log.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableList;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.ObjectWithJsonToString;

public abstract class LogEntry
extends ObjectWithJsonToString {
    private static final String[] excludedFields = new String[]{"timestamp"};
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final List<HttpRequest> httpRequest;
    private final Date timestamp = new Date();

    LogEntry(List<HttpRequest> httpRequests) {
        this.httpRequest = httpRequests != null && !httpRequests.isEmpty() ? httpRequests : ImmutableList.of((Object)HttpRequest.request());
    }

    LogEntry(HttpRequest httpRequest) {
        this((List<HttpRequest>)ImmutableList.of((Object)(httpRequest != null ? httpRequest : HttpRequest.request())));
    }

    @JsonIgnore
    public List<HttpRequest> getHttpRequests() {
        return this.httpRequest;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest.get(0);
    }

    public String getTimestamp() {
        return dateFormat.format(this.timestamp);
    }

    @Override
    @JsonIgnore
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

