/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import net.minidev.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.model.HttpRequest;

public class JsonPathMatcher
extends BodyMatcher<String> {
    private static final String[] excludedFields = new String[]{"mockServerLogger", "jsonPath"};
    private final MockServerLogger mockServerLogger;
    private final String matcher;
    private JsonPath jsonPath;

    public JsonPathMatcher(MockServerLogger mockServerLogger, String matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
        if (StringUtils.isNotBlank((CharSequence)matcher)) {
            try {
                this.jsonPath = JsonPath.compile((String)matcher, (Predicate[])new Predicate[0]);
            }
            catch (Throwable throwable) {
                mockServerLogger.trace("Error while creating xpath expression for [" + matcher + "] assuming matcher not xpath - " + throwable.getMessage(), throwable);
            }
        }
    }

    @Override
    public boolean matches(HttpRequest context, String matched) {
        boolean result = false;
        if (this.jsonPath == null) {
            this.mockServerLogger.trace(context, "Attempting match against null XPath Expression for [" + matched + "]" + new RuntimeException("Attempting match against null XPath Expression for [" + matched + "]"), new Object[0]);
        } else if (this.matcher.equals(matched)) {
            result = true;
        } else if (matched != null) {
            try {
                result = !((JSONArray)this.jsonPath.read(matched)).isEmpty();
            }
            catch (Exception e) {
                this.mockServerLogger.trace(context, "Failed to match JSON: {}with JsonPath: {}because: {}", matched, this.jsonPath, e.getMessage());
            }
        }
        if (!result) {
            this.mockServerLogger.trace("Failed to match [{}] with [{}]", matched, this.matcher);
        }
        return this.not != result;
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

