/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.collections.CircularLinkedList;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.metrics.Metrics;
import org.mockserver.mock.Expectation;
import org.mockserver.model.Action;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.ui.MockServerMatcherNotifier;

public class MockServerMatcher
extends MockServerMatcherNotifier {
    final List<HttpRequestMatcher> httpRequestMatchers = Collections.synchronizedList(new CircularLinkedList(ConfigurationProperties.maxExpectations()));
    private WebSocketClientRegistry webSocketClientRegistry;
    private MatcherBuilder matcherBuilder;

    MockServerMatcher(MockServerLogger logFormatter, Scheduler scheduler, WebSocketClientRegistry webSocketClientRegistry) {
        super(scheduler);
        this.matcherBuilder = new MatcherBuilder(logFormatter);
        this.webSocketClientRegistry = webSocketClientRegistry;
    }

    public synchronized void add(Expectation expectation) {
        this.httpRequestMatchers.add(this.matcherBuilder.transformsToMatcher(expectation));
        this.notifyListeners(this);
        if (expectation != null && expectation.getAction() != null) {
            Metrics.increment(expectation.getAction().getType());
        }
    }

    private synchronized List<HttpRequestMatcher> cloneMatchers() {
        return new ArrayList<HttpRequestMatcher>(this.httpRequestMatchers);
    }

    public synchronized void reset() {
        this.httpRequestMatchers.clear();
        Metrics.clearActionMetrics();
        this.notifyListeners(this);
    }

    public Expectation firstMatchingExpectation(HttpRequest httpRequest) {
        Expectation matchingExpectation = null;
        for (HttpRequestMatcher httpRequestMatcher : this.cloneMatchers()) {
            if (httpRequestMatcher.matches(httpRequest, httpRequest)) {
                matchingExpectation = httpRequestMatcher.decrementRemainingMatches();
            }
            if (!httpRequestMatcher.isActive()) {
                this.removeHttpRequestMatcher(httpRequestMatcher);
            }
            if (matchingExpectation == null) continue;
            break;
        }
        if (matchingExpectation == null || matchingExpectation.getAction() == null) {
            Metrics.increment(Metrics.Name.EXPECTATION_NOT_MATCHED_COUNT);
        } else if (matchingExpectation.getAction().getType().direction == Action.Direction.FORWARD) {
            Metrics.increment(Metrics.Name.FORWARD_EXPECTATION_MATCHED_COUNT);
        } else {
            Metrics.increment(Metrics.Name.RESPONSE_EXPECTATION_MATCHED_COUNT);
        }
        return matchingExpectation;
    }

    public void clear(HttpRequest httpRequest) {
        if (httpRequest != null) {
            HttpRequestMatcher clearHttpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            for (HttpRequestMatcher httpRequestMatcher : this.cloneMatchers()) {
                if (!clearHttpRequestMatcher.matches(httpRequestMatcher.getExpectation().getHttpRequest())) continue;
                this.removeHttpRequestMatcher(httpRequestMatcher);
            }
        } else {
            this.reset();
        }
    }

    private void removeHttpRequestMatcher(HttpRequestMatcher httpRequestMatcher) {
        if (this.httpRequestMatchers.contains(httpRequestMatcher)) {
            Action action;
            this.httpRequestMatchers.remove(httpRequestMatcher);
            if (httpRequestMatcher.getExpectation() != null && (action = httpRequestMatcher.getExpectation().getAction()) != null) {
                switch (action.getType()) {
                    case FORWARD_OBJECT_CALLBACK: {
                        this.webSocketClientRegistry.unregisterForwardCallbackHandler(((HttpObjectCallback)action).getClientId());
                        break;
                    }
                    case RESPONSE_OBJECT_CALLBACK: {
                        this.webSocketClientRegistry.unregisterResponseCallbackHandler(((HttpObjectCallback)action).getClientId());
                    }
                }
                Metrics.decrement(action.getType());
            }
            this.notifyListeners(this);
        }
    }

    public List<Expectation> retrieveExpectations(HttpRequest httpRequest) {
        ArrayList<Expectation> expectations = new ArrayList<Expectation>();
        HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
        for (HttpRequestMatcher httpRequestMatcher : this.cloneMatchers()) {
            if (httpRequest != null && !requestMatcher.matches(httpRequestMatcher.getExpectation().getHttpRequest())) continue;
            expectations.add(httpRequestMatcher.getExpectation());
        }
        return expectations;
    }

    public boolean isEmpty() {
        return this.httpRequestMatchers.isEmpty();
    }
}

