/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.concurrent.TimeUnit;
import org.mockserver.model.Delay;
import org.mockserver.model.ObjectWithJsonToString;

public abstract class Action<T extends Action>
extends ObjectWithJsonToString {
    private Delay delay;

    public T withDelay(Delay delay) {
        this.delay = delay;
        return (T)this;
    }

    public T withDelay(TimeUnit timeUnit, long value) {
        this.delay = new Delay(timeUnit, value);
        return (T)this;
    }

    public Delay getDelay() {
        return this.delay;
    }

    @JsonIgnore
    public abstract Type getType();

    public static enum Direction {
        FORWARD,
        RESPONSE;

    }

    public static enum Type {
        FORWARD(Direction.FORWARD),
        FORWARD_TEMPLATE(Direction.FORWARD),
        FORWARD_CLASS_CALLBACK(Direction.FORWARD),
        FORWARD_OBJECT_CALLBACK(Direction.FORWARD),
        FORWARD_REPLACE(Direction.FORWARD),
        RESPONSE(Direction.RESPONSE),
        RESPONSE_TEMPLATE(Direction.RESPONSE),
        RESPONSE_CLASS_CALLBACK(Direction.RESPONSE),
        RESPONSE_OBJECT_CALLBACK(Direction.RESPONSE),
        ERROR(Direction.RESPONSE);

        public final Direction direction;

        private Type(Direction direction) {
            this.direction = direction;
        }
    }
}

