/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mockserver.character.Character;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.JsonArraySerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.mockserver.serialization.model.HttpRequestDTO;
import org.mockserver.templates.engine.model.HttpRequestTemplateObject;
import org.mockserver.validator.jsonschema.JsonSchemaHttpRequestValidator;

public class HttpRequestSerializer
implements Serializer<HttpRequest> {
    private final MockServerLogger mockServerLogger;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();
    private JsonSchemaHttpRequestValidator httpRequestValidator;

    public HttpRequestSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.httpRequestValidator = new JsonSchemaHttpRequestValidator(mockServerLogger);
    }

    @Override
    public String serialize(HttpRequest httpRequest) {
        return this.serialize(false, httpRequest);
    }

    public String serialize(boolean prettyPrint, HttpRequest httpRequest) {
        try {
            if (prettyPrint) {
                return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new HttpRequestTemplateObject(httpRequest));
            }
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new HttpRequestDTO(httpRequest));
        }
        catch (Exception e) {
            this.mockServerLogger.error(String.format("Exception while serializing HttpRequest to JSON with value %s", httpRequest), e);
            throw new RuntimeException(String.format("Exception while serializing HttpRequest to JSON with value %s", httpRequest), e);
        }
    }

    @Override
    public String serialize(List<HttpRequest> httpRequests) {
        return this.serialize(false, httpRequests);
    }

    public String serialize(boolean prettyPrint, List<HttpRequest> httpRequests) {
        return this.serialize(prettyPrint, httpRequests.toArray(new HttpRequest[httpRequests.size()]));
    }

    @Override
    public String serialize(HttpRequest ... httpRequests) {
        return this.serialize(false, httpRequests);
    }

    public String serialize(boolean prettyPrint, HttpRequest ... httpRequests) {
        try {
            if (httpRequests != null && httpRequests.length > 0) {
                if (prettyPrint) {
                    HttpRequestTemplateObject[] httpRequestTemplateObjects = new HttpRequestTemplateObject[httpRequests.length];
                    for (int i = 0; i < httpRequests.length; ++i) {
                        httpRequestTemplateObjects[i] = new HttpRequestTemplateObject(httpRequests[i]);
                    }
                    return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)httpRequestTemplateObjects);
                }
                HttpRequestDTO[] httpRequestDTOs = new HttpRequestDTO[httpRequests.length];
                for (int i = 0; i < httpRequests.length; ++i) {
                    httpRequestDTOs[i] = new HttpRequestDTO(httpRequests[i]);
                }
                return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)httpRequestDTOs);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.error("Exception while serializing HttpRequest to JSON with value " + Arrays.asList(httpRequests), e);
            throw new RuntimeException("Exception while serializing HttpRequest to JSON with value " + Arrays.asList(httpRequests), e);
        }
    }

    @Override
    public HttpRequest deserialize(String jsonHttpRequest) {
        String validationErrors;
        if (Strings.isNullOrEmpty((String)jsonHttpRequest)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request is required but value was \"" + String.valueOf(jsonHttpRequest) + "\"");
        }
        if (jsonHttpRequest.contains("\"httpRequest\"")) {
            try {
                JsonNode jsonNode = this.objectMapper.readTree(jsonHttpRequest);
                if (jsonNode.has("httpRequest")) {
                    jsonHttpRequest = jsonNode.get("httpRequest").toString();
                }
            }
            catch (Exception e) {
                this.mockServerLogger.error((HttpRequest)null, (Throwable)e, "exception while parsing {}for HttpRequest", jsonHttpRequest);
                throw new RuntimeException("Exception while parsing [" + jsonHttpRequest + "] for HttpRequest", e);
            }
        }
        if ((validationErrors = this.httpRequestValidator.isValid(jsonHttpRequest)).isEmpty()) {
            HttpRequest httpRequest = null;
            try {
                HttpRequestDTO httpRequestDTO = (HttpRequestDTO)this.objectMapper.readValue(jsonHttpRequest, HttpRequestDTO.class);
                if (httpRequestDTO != null) {
                    httpRequest = httpRequestDTO.buildObject();
                }
            }
            catch (Exception e) {
                this.mockServerLogger.error((HttpRequest)null, (Throwable)e, "exception while parsing {}for HttpRequest", jsonHttpRequest);
                throw new RuntimeException("Exception while parsing [" + jsonHttpRequest + "] for HttpRequest", e);
            }
            return httpRequest;
        }
        this.mockServerLogger.error("validation failed:{}request:{}", validationErrors, jsonHttpRequest);
        throw new IllegalArgumentException(validationErrors);
    }

    @Override
    public Class<HttpRequest> supportsType() {
        return HttpRequest.class;
    }

    public HttpRequest[] deserializeArray(String jsonHttpRequests) {
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        if (Strings.isNullOrEmpty((String)jsonHttpRequests)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request or request array is required but value was \"" + String.valueOf(jsonHttpRequests) + "\"");
        }
        List<String> jsonRequestList = this.jsonArraySerializer.returnJSONObjects(jsonHttpRequests);
        if (jsonRequestList.isEmpty()) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a request or array of request is required");
        }
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        for (String jsonExpecation : jsonRequestList) {
            try {
                httpRequests.add(this.deserialize(jsonExpecation));
            }
            catch (IllegalArgumentException iae) {
                validationErrorsList.add(iae.getMessage());
            }
        }
        if (!validationErrorsList.isEmpty()) {
            throw new IllegalArgumentException((validationErrorsList.size() > 1 ? "[" : "") + Joiner.on((String)("," + Character.NEW_LINE)).join(validationErrorsList) + (validationErrorsList.size() > 1 ? "]" : ""));
        }
        return httpRequests.toArray(new HttpRequest[httpRequests.size()]);
    }
}

