/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mockserver.character.Character;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.serialization.JsonArraySerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.mockserver.serialization.model.HttpResponseDTO;
import org.mockserver.validator.jsonschema.JsonSchemaHttpResponseValidator;

public class HttpResponseSerializer
implements Serializer<HttpResponse> {
    private final MockServerLogger mockServerLogger;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();
    private JsonSchemaHttpResponseValidator httpResponseValidator;

    public HttpResponseSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.httpResponseValidator = new JsonSchemaHttpResponseValidator(mockServerLogger);
    }

    @Override
    public String serialize(HttpResponse httpResponse) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new HttpResponseDTO(httpResponse));
        }
        catch (Exception e) {
            this.mockServerLogger.error(String.format("Exception while serializing httpResponse to JSON with value %s", httpResponse), e);
            throw new RuntimeException(String.format("Exception while serializing httpResponse to JSON with value %s", httpResponse), e);
        }
    }

    @Override
    public String serialize(List<HttpResponse> httpResponses) {
        return this.serialize(httpResponses.toArray(new HttpResponse[httpResponses.size()]));
    }

    @Override
    public String serialize(HttpResponse ... httpResponses) {
        try {
            if (httpResponses != null && httpResponses.length > 0) {
                HttpResponseDTO[] httpResponseDTOs = new HttpResponseDTO[httpResponses.length];
                for (int i = 0; i < httpResponses.length; ++i) {
                    httpResponseDTOs[i] = new HttpResponseDTO(httpResponses[i]);
                }
                return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)httpResponseDTOs);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.error("Exception while serializing HttpResponse to JSON with value " + Arrays.asList(httpResponses), e);
            throw new RuntimeException("Exception while serializing HttpResponse to JSON with value " + Arrays.asList(httpResponses), e);
        }
    }

    @Override
    public HttpResponse deserialize(String jsonHttpResponse) {
        String validationErrors;
        if (Strings.isNullOrEmpty((String)jsonHttpResponse)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a response is required but value was \"" + String.valueOf(jsonHttpResponse) + "\"");
        }
        if (jsonHttpResponse.contains("\"httpResponse\"")) {
            try {
                JsonNode jsonNode = this.objectMapper.readTree(jsonHttpResponse);
                if (jsonNode.has("httpResponse")) {
                    jsonHttpResponse = jsonNode.get("httpResponse").toString();
                }
            }
            catch (Exception e) {
                this.mockServerLogger.error((HttpRequest)null, (Throwable)e, "exception while parsing {}for HttpResponse", jsonHttpResponse);
                throw new RuntimeException("Exception while parsing [" + jsonHttpResponse + "] for HttpResponse", e);
            }
        }
        if ((validationErrors = this.httpResponseValidator.isValid(jsonHttpResponse)).isEmpty()) {
            HttpResponse httpResponse = null;
            try {
                HttpResponseDTO httpResponseDTO = (HttpResponseDTO)this.objectMapper.readValue(jsonHttpResponse, HttpResponseDTO.class);
                if (httpResponseDTO != null) {
                    httpResponse = httpResponseDTO.buildObject();
                }
            }
            catch (Exception e) {
                this.mockServerLogger.error((HttpRequest)null, (Throwable)e, "exception while parsing {}for HttpResponse", jsonHttpResponse);
                throw new RuntimeException("Exception while parsing [" + jsonHttpResponse + "] for HttpResponse", e);
            }
            return httpResponse;
        }
        this.mockServerLogger.error("validation failed:{}response:{}", validationErrors, jsonHttpResponse);
        throw new IllegalArgumentException(validationErrors);
    }

    @Override
    public Class<HttpResponse> supportsType() {
        return HttpResponse.class;
    }

    public HttpResponse[] deserializeArray(String jsonHttpResponses) {
        ArrayList<HttpResponse> httpResponses = new ArrayList<HttpResponse>();
        if (Strings.isNullOrEmpty((String)jsonHttpResponses)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a response or response array is required but value was \"" + String.valueOf(jsonHttpResponses) + "\"");
        }
        List<String> jsonResponseList = this.jsonArraySerializer.returnJSONObjects(jsonHttpResponses);
        if (jsonResponseList.isEmpty()) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a response or array of response is required");
        }
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        for (String jsonExpecation : jsonResponseList) {
            try {
                httpResponses.add(this.deserialize(jsonExpecation));
            }
            catch (IllegalArgumentException iae) {
                validationErrorsList.add(iae.getMessage());
            }
        }
        if (!validationErrorsList.isEmpty()) {
            throw new IllegalArgumentException((validationErrorsList.size() > 1 ? "[" : "") + Joiner.on((String)("," + Character.NEW_LINE)).join(validationErrorsList) + (validationErrorsList.size() > 1 ? "]" : ""));
        }
        return httpResponses.toArray(new HttpResponse[httpResponses.size()]);
    }
}

