/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;

public class LogEventJsonSerializer
implements Serializer<MessageLogEntry> {
    private final MockServerLogger mockServerLogger;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();

    public LogEventJsonSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    @Override
    public String serialize(MessageLogEntry messageLogEntry) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)messageLogEntry);
        }
        catch (Exception e) {
            this.mockServerLogger.error(String.format("Exception while serializing messageLogEntry to JSON with value %s", messageLogEntry), e);
            throw new RuntimeException(String.format("Exception while serializing messageLogEntry to JSON with value %s", messageLogEntry), e);
        }
    }

    @Override
    public String serialize(List<MessageLogEntry> messageLogEntries) {
        return this.serialize(messageLogEntries.toArray(new MessageLogEntry[messageLogEntries.size()]));
    }

    @Override
    public String serialize(MessageLogEntry ... messageLogEntries) {
        try {
            if (messageLogEntries != null && messageLogEntries.length > 0) {
                return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)messageLogEntries);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.error("Exception while serializing MessageLogEntry to JSON with value " + Arrays.asList(messageLogEntries), e);
            throw new RuntimeException("Exception while serializing MessageLogEntry to JSON with value " + Arrays.asList(messageLogEntries), e);
        }
    }

    @Override
    public MessageLogEntry deserialize(String jsonMessageLogEntry) {
        MessageLogEntry messageLogEntry = null;
        if (jsonMessageLogEntry != null && !jsonMessageLogEntry.isEmpty()) {
            try {
                messageLogEntry = (MessageLogEntry)this.objectMapper.readValue(jsonMessageLogEntry, MessageLogEntry.class);
            }
            catch (Exception e) {
                this.mockServerLogger.error((HttpRequest)null, (Throwable)e, "exception while parsing {}for MessageLogEntry", jsonMessageLogEntry);
                throw new RuntimeException("Exception while parsing MessageLogEntry for [" + jsonMessageLogEntry + "]", e);
            }
        }
        return messageLogEntry;
    }

    @Override
    public Class<MessageLogEntry> supportsType() {
        return MessageLogEntry.class;
    }
}

