/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import org.mockserver.character.Character;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.mockserver.serialization.model.VerificationSequenceDTO;
import org.mockserver.validator.jsonschema.JsonSchemaVerificationSequenceValidator;
import org.mockserver.verify.VerificationSequence;

public class VerificationSequenceSerializer
implements Serializer<VerificationSequence> {
    private final MockServerLogger mockServerLogger;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private JsonSchemaVerificationSequenceValidator verificationSequenceValidator;

    public VerificationSequenceSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.verificationSequenceValidator = new JsonSchemaVerificationSequenceValidator(mockServerLogger);
    }

    @Override
    public String serialize(VerificationSequence verificationSequence) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new VerificationSequenceDTO(verificationSequence));
        }
        catch (Exception e) {
            this.mockServerLogger.error("Exception while serializing verificationSequence to JSON with value " + verificationSequence, e);
            throw new RuntimeException("Exception while serializing verificationSequence to JSON with value " + verificationSequence, e);
        }
    }

    @Override
    public VerificationSequence deserialize(String jsonVerificationSequence) {
        if (Strings.isNullOrEmpty((String)jsonVerificationSequence)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a verification sequence is required but value was \"" + String.valueOf(jsonVerificationSequence) + "\"");
        }
        String validationErrors = this.verificationSequenceValidator.isValid(jsonVerificationSequence);
        if (validationErrors.isEmpty()) {
            VerificationSequence verificationSequence = null;
            try {
                VerificationSequenceDTO verificationDTO = (VerificationSequenceDTO)this.objectMapper.readValue(jsonVerificationSequence, VerificationSequenceDTO.class);
                if (verificationDTO != null) {
                    verificationSequence = verificationDTO.buildObject();
                }
            }
            catch (Exception e) {
                this.mockServerLogger.error((HttpRequest)null, (Throwable)e, "exception while parsing {}for VerificationSequence", jsonVerificationSequence);
                throw new RuntimeException("Exception while parsing [" + jsonVerificationSequence + "] for VerificationSequence", e);
            }
            return verificationSequence;
        }
        this.mockServerLogger.info(MessageLogEntry.LogMessageType.VERIFICATION_FAILED, "validation failed:{}verification sequence:{}", validationErrors, jsonVerificationSequence);
        throw new IllegalArgumentException(validationErrors);
    }

    @Override
    public Class<VerificationSequence> supportsType() {
        return VerificationSequence.class;
    }
}

