/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.server.initialize;

import java.lang.reflect.Constructor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.file.FileReader;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.serialization.ExpectationSerializer;
import org.mockserver.server.initialize.ExpectationInitializer;

public class ExpectationInitializerLoader {
    private static ExpectationSerializer expectationSerializer = new ExpectationSerializer(new MockServerLogger());

    private static Expectation[] retrieveExpectationsFromInitializerClass() {
        try {
            Constructor<?> initializerClassConstructor;
            Object expectationInitializer;
            ClassLoader contextClassLoader;
            String initializationClass = ConfigurationProperties.initializationClass();
            if (StringUtils.isNotBlank((CharSequence)initializationClass) && (contextClassLoader = ExpectationInitializerLoader.class.getClassLoader()) != null && StringUtils.isNotEmpty((CharSequence)initializationClass) && (expectationInitializer = (initializerClassConstructor = contextClassLoader.loadClass(initializationClass).getDeclaredConstructor(new Class[0])).newInstance(new Object[0])) instanceof ExpectationInitializer) {
                return ((ExpectationInitializer)expectationInitializer).initializeExpectations();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new Expectation[0];
    }

    private static Expectation[] retrieveExpectationsFromJson() {
        String initializationJsonPath = ConfigurationProperties.initializationJsonPath();
        if (StringUtils.isNotBlank((CharSequence)initializationJsonPath)) {
            return expectationSerializer.deserializeArray(FileReader.readFileFromClassPathOrPath(initializationJsonPath));
        }
        return new Expectation[0];
    }

    public static Expectation[] loadExpectations() {
        Object[] expectationsFromInitializerClass = ExpectationInitializerLoader.retrieveExpectationsFromInitializerClass();
        Object[] expectationsFromJson = ExpectationInitializerLoader.retrieveExpectationsFromJson();
        return (Expectation[])ArrayUtils.addAll((Object[])expectationsFromInitializerClass, (Object[])expectationsFromJson);
    }
}

