/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket.tls;

import com.google.common.base.Strings;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.AbstractSniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.PlatformDependent;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.socket.tls.NettySslContextFactory;

public class SniHandler
extends AbstractSniHandler<SslContext> {
    protected Future<SslContext> lookup(ChannelHandlerContext ctx, String hostname) {
        if (!Strings.isNullOrEmpty((String)hostname)) {
            ConfigurationProperties.addSslSubjectAlternativeNameDomains(hostname);
        }
        return ctx.executor().newSucceededFuture((Object)NettySslContextFactory.nettySslContextFactory().createServerSslContext());
    }

    protected void onLookupComplete(ChannelHandlerContext ctx, String hostname, Future<SslContext> sslContextFuture) {
        if (!sslContextFuture.isSuccess()) {
            Throwable cause = sslContextFuture.cause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new DecoderException("Failed to get the SslContext for " + hostname, cause);
        }
        try {
            this.replaceHandler(ctx, sslContextFuture);
        }
        catch (Throwable cause) {
            PlatformDependent.throwException((Throwable)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceHandler(ChannelHandlerContext ctx, Future<SslContext> sslContext) {
        SslHandler sslHandler = null;
        try {
            sslHandler = ((SslContext)sslContext.getNow()).newHandler(ctx.alloc());
            ctx.pipeline().replace((ChannelHandler)this, SslHandler.class.getName(), (ChannelHandler)sslHandler);
            sslHandler = null;
        }
        finally {
            if (sslHandler != null) {
                ReferenceCountUtil.safeRelease((Object)sslHandler.engine());
            }
        }
    }
}

