/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.websocket;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import javax.net.ssl.SSLException;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.ExpectationCallback;
import org.mockserver.model.HttpObject;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.WebSocketMessageSerializer;
import org.mockserver.serialization.model.WebSocketClientIdDTO;
import org.mockserver.serialization.model.WebSocketErrorDTO;
import org.mockserver.websocket.WebSocketClientHandler;
import org.mockserver.websocket.WebSocketException;

public class WebSocketClient<T extends HttpObject> {
    static final AttributeKey<SettableFuture<String>> REGISTRATION_FUTURE = AttributeKey.valueOf((String)"REGISTRATION_FUTURE");
    private final MockServerLogger mockServerLogger = new MockServerLogger(this.getClass());
    private final Semaphore availableWebSocketCallbackRegistrations;
    private Channel channel;
    private WebSocketMessageSerializer webSocketMessageSerializer = new WebSocketMessageSerializer(new MockServerLogger());
    private ExpectationCallback<T> expectationCallback;

    public WebSocketClient(Semaphore availableWebSocketCallbackRegistrations) {
        this.availableWebSocketCallbackRegistrations = availableWebSocketCallbackRegistrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<String> register(EventLoopGroup eventLoopGroup, final InetSocketAddress serverAddress, final String contextPath, final boolean isSecure) {
        SettableFuture registrationFuture = SettableFuture.create();
        if (this.availableWebSocketCallbackRegistrations.tryAcquire()) {
            try {
                ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioSocketChannel.class)).attr(REGISTRATION_FUTURE, (Object)registrationFuture)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    protected void initChannel(SocketChannel ch) throws URISyntaxException {
                        if (isSecure) {
                            try {
                                ch.pipeline().addLast(new ChannelHandler[]{SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(InsecureTrustManagerFactory.INSTANCE).build().newHandler(ch.alloc(), serverAddress.getHostName(), serverAddress.getPort())});
                            }
                            catch (SSLException e) {
                                throw new WebSocketException("Exception when configuring SSL Handler", e);
                            }
                        }
                        ch.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(Integer.MAX_VALUE), new WebSocketClientHandler(serverAddress, contextPath, WebSocketClient.this)});
                    }
                })).connect((SocketAddress)serverAddress).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) {
                        WebSocketClient.this.channel = channelFuture.channel();
                        WebSocketClient.this.channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture channelFuture) {
                            }
                        });
                    }
                });
            }
            catch (Exception e) {
                registrationFuture.setException((Throwable)new WebSocketException("Exception while starting web socket client", e));
            }
            finally {
                this.availableWebSocketCallbackRegistrations.release();
            }
        } else {
            registrationFuture.setException((Throwable)new WebSocketException("It is not possible to re-use the same MockServerClient instance to register a new object callback while responding to an object callback, please use a separate instance of the MockServerClient inside a callback"));
        }
        return registrationFuture;
    }

    void receivedTextWebSocketFrame(TextWebSocketFrame textWebSocketFrame) {
        try {
            this.availableWebSocketCallbackRegistrations.tryAcquire();
            Object deserializedMessage = this.webSocketMessageSerializer.deserialize(textWebSocketFrame.text());
            if (deserializedMessage instanceof HttpRequest) {
                HttpRequest httpRequest = (HttpRequest)deserializedMessage;
                String webSocketCorrelationId = httpRequest.getFirstHeader("WebSocketCorrelationId");
                if (this.expectationCallback != null) {
                    try {
                        T result = this.expectationCallback.handle(httpRequest);
                        result.withHeader("WebSocketCorrelationId", webSocketCorrelationId);
                        this.channel.writeAndFlush((Object)new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(result)));
                    }
                    catch (Throwable throwable) {
                        this.mockServerLogger.error("Exception thrown while handling callback", throwable);
                        this.channel.writeAndFlush((Object)new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(new WebSocketErrorDTO().setMessage(throwable.getMessage()).setWebSocketCorrelationId(webSocketCorrelationId))));
                    }
                }
            } else if (!(deserializedMessage instanceof WebSocketClientIdDTO)) {
                throw new WebSocketException("Unsupported web socket message " + deserializedMessage);
            }
        }
        catch (Exception e) {
            throw new WebSocketException("Exception while receiving web socket message", e);
        }
        finally {
            this.availableWebSocketCallbackRegistrations.release();
        }
    }

    public void stopClient() {
        try {
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close().sync();
                this.channel = null;
            }
        }
        catch (InterruptedException e) {
            throw new WebSocketException("Exception while closing client", e);
        }
    }

    public Future<String> registerExpectationCallback(ExpectationCallback<T> expectationCallback, EventLoopGroup eventLoopGroup, InetSocketAddress serverAddress, String contextPath, boolean isSecure) {
        if (this.expectationCallback == null) {
            this.expectationCallback = expectationCallback;
            return this.register(eventLoopGroup, serverAddress, contextPath, isSecure);
        }
        throw new IllegalArgumentException("It is not possible to set response callback once a forward callback has been set");
    }
}

