/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.junit;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockserver.client.MockServerClient;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.socket.PortFactory;

public class MockServerRule
implements TestRule {
    @VisibleForTesting
    static ClientAndServer perTestSuiteClientAndServer;
    private final Object target;
    private final Integer[] ports;
    private final boolean perTestSuite;
    private ClientAndServerFactory clientAndServerFactory;
    private ClientAndServer clientAndServer;

    public MockServerRule(Object target) {
        this(target, PortFactory.findFreePort());
    }

    public MockServerRule(Object target, boolean perTestSuite) {
        this(target, perTestSuite, PortFactory.findFreePort());
    }

    public MockServerRule(Object target, Integer ... ports) {
        this(target, true, ports);
    }

    public MockServerRule(Object target, boolean perTestSuite, Integer ... ports) {
        this.ports = ports;
        this.target = target;
        this.perTestSuite = perTestSuite;
        this.clientAndServerFactory = new ClientAndServerFactory(ports);
    }

    public Integer getPort() {
        Integer port = null;
        if (this.clientAndServer != null) {
            port = this.clientAndServer.getPort();
        } else if (this.ports.length > 0) {
            port = this.ports[0];
        }
        return port;
    }

    public Integer[] getPorts() {
        if (this.clientAndServer != null) {
            List ports = this.clientAndServer.getLocalPorts();
            return ports.toArray(new Integer[0]);
        }
        return this.ports;
    }

    public Statement apply(Statement base, Description description) {
        return this.statement(base);
    }

    private Statement statement(final Statement base) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                if (MockServerRule.this.perTestSuite) {
                    Class<MockServerRule> clazz = MockServerRule.class;
                    synchronized (MockServerRule.class) {
                        if (perTestSuiteClientAndServer == null) {
                            perTestSuiteClientAndServer = MockServerRule.this.clientAndServerFactory.newClientAndServer();
                        } else {
                            perTestSuiteClientAndServer.reset();
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        MockServerRule.this.clientAndServer = perTestSuiteClientAndServer;
                        MockServerRule.this.setMockServerClient(MockServerRule.this.target, perTestSuiteClientAndServer);
                        base.evaluate();
                    }
                } else {
                    MockServerRule.this.clientAndServer = MockServerRule.this.clientAndServerFactory.newClientAndServer();
                    MockServerRule.this.setMockServerClient(MockServerRule.this.target, MockServerRule.this.clientAndServer);
                    try {
                        base.evaluate();
                    }
                    finally {
                        MockServerRule.this.clientAndServer.stop();
                    }
                }
                {
                    return;
                }
            }
        };
    }

    private void setMockServerClient(Object target, ClientAndServer clientAndServer) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = target instanceof Class ? (Class<?>)target : target.getClass();
        while (!clazz.equals(Object.class)) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.getType().equals(MockServerClient.class)) continue;
                field.setAccessible(true);
                try {
                    field.set(target, clientAndServer);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Error setting MockServerClient field on " + target.getClass().getName(), e);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    public MockServerClient getClient() {
        return this.clientAndServer;
    }

    @VisibleForTesting
    static class ClientAndServerFactory {
        private final Integer[] port;

        public ClientAndServerFactory(Integer ... port) {
            this.port = port;
        }

        public ClientAndServer newClientAndServer() {
            return ClientAndServer.startClientAndServer((Integer[])this.port);
        }
    }
}

