/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http;

import com.google.common.net.MediaType;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import org.mockserver.character.Character;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.client.serialization.curl.HttpRequestToCurlSerializer;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.cors.CORSHeaders;
import org.mockserver.filters.Filter;
import org.mockserver.filters.Filters;
import org.mockserver.filters.HopByHopHeaderFilter;
import org.mockserver.filters.RequestLogFilter;
import org.mockserver.filters.RequestResponseLogFilter;
import org.mockserver.logging.LogFormatter;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.connect.HttpConnectHandler;
import org.mockserver.proxy.error.Logging;
import org.mockserver.proxy.unification.PortUnificationHandler;
import org.mockserver.socket.KeyAndCertificateFactory;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpProxyHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Proxy server;
    private final RequestLogFilter requestLogFilter;
    private final RequestResponseLogFilter requestResponseLogFilter;
    private final Filters filters = new Filters();
    private LogFormatter logFormatter = new LogFormatter(this.logger);
    private NettyHttpClient httpClient = new NettyHttpClient();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private HttpRequestToCurlSerializer httpRequestToCurlSerializer = new HttpRequestToCurlSerializer();
    private VerificationSerializer verificationSerializer = new VerificationSerializer();
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();
    private CORSHeaders addCORSHeaders = new CORSHeaders();

    public HttpProxyHandler(Proxy server, RequestLogFilter requestLogFilter, RequestResponseLogFilter requestResponseLogFilter) {
        super(false);
        this.server = server;
        this.requestLogFilter = requestLogFilter;
        this.requestResponseLogFilter = requestResponseLogFilter;
        this.filters.withFilter(HttpRequest.request(), (Filter)requestLogFilter);
        this.filters.withFilter(HttpRequest.request(), (Filter)requestResponseLogFilter);
        this.filters.withFilter(HttpRequest.request(), (Filter)new HopByHopHeaderFilter());
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        try {
            this.logFormatter.traceLog("received request:{}" + Character.NEW_LINE, new Object[]{request});
            if (request.getMethod().getValue().equals("CONNECT")) {
                PortUnificationHandler.enabledSslUpstreamAndDownstream(ctx.channel());
                KeyAndCertificateFactory.addSubjectAlternativeName((String)request.getPath().getValue());
                ctx.pipeline().addLast(new ChannelHandler[]{new HttpConnectHandler(request.getPath().getValue(), -1)});
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.fireChannelRead((Object)request);
            } else if ((ConfigurationProperties.enableCORSForAPI() || ConfigurationProperties.enableCORSForAllResponses()) && request.getMethod().getValue().equals("OPTIONS") && !request.getFirstHeader("Origin").isEmpty()) {
                this.writeResponse(ctx, request, HttpResponseStatus.OK);
            } else if (request.matches("PUT", "/status")) {
                this.writeResponse(ctx, request, HttpResponseStatus.OK);
            } else if (request.matches("PUT", "/clear")) {
                HttpRequest httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
                this.requestResponseLogFilter.clear(httpRequest);
                this.requestLogFilter.clear(httpRequest);
                this.logFormatter.infoLog("clearing expectations and request logs that match:{}", new Object[]{httpRequest});
                this.writeResponse(ctx, request, HttpResponseStatus.OK);
            } else if (request.matches("PUT", "/reset")) {
                this.requestLogFilter.reset();
                this.logFormatter.infoLog("resetting all expectations and request logs", new Object[0]);
                this.writeResponse(ctx, request, HttpResponseStatus.OK);
            } else if (request.matches("PUT", "/dumpToLog")) {
                this.requestResponseLogFilter.dumpToLog(this.httpRequestSerializer.deserialize(request.getBodyAsString()), request.hasQueryStringParameter("type", "java"));
                this.writeResponse(ctx, request, HttpResponseStatus.OK);
            } else if (request.matches("PUT", "/retrieve")) {
                HttpRequest[] requests = this.requestLogFilter.retrieve(this.httpRequestSerializer.deserialize(request.getBodyAsString()));
                this.writeResponse(ctx, request, HttpResponseStatus.OK, this.httpRequestSerializer.serialize(requests), "application/json");
            } else if (request.matches("PUT", "/verify")) {
                Verification verification = this.verificationSerializer.deserialize(request.getBodyAsString());
                this.logFormatter.infoLog("verifying:{}", new Object[]{verification});
                String result = this.requestLogFilter.verify(verification);
                this.verifyResponse(ctx, request, result);
            } else if (request.matches("PUT", "/verifySequence")) {
                VerificationSequence verificationSequence = this.verificationSequenceSerializer.deserialize(request.getBodyAsString());
                String result = this.requestLogFilter.verify(verificationSequence);
                this.logFormatter.infoLog("verifying sequence:{}", new Object[]{verificationSequence});
                this.verifyResponse(ctx, request, result);
            } else if (request.matches("PUT", "/stop")) {
                ctx.writeAndFlush((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.OK.code())));
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        HttpProxyHandler.this.server.stop();
                    }
                }).start();
            } else {
                InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().attr(Proxy.REMOTE_SOCKET).get();
                HttpResponse response = this.sendRequest(request, remoteAddress);
                this.writeResponse(ctx, request, response);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception processing " + request, (Throwable)e);
            this.writeResponse(ctx, request, HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.BAD_REQUEST.code())).withBody(e.getMessage()));
        }
    }

    private void verifyResponse(ChannelHandlerContext ctx, HttpRequest request, String result) {
        if (result.isEmpty()) {
            this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
        } else {
            this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, result, MediaType.create((String)"text", (String)"plain").toString());
        }
    }

    private HttpResponse sendRequest(HttpRequest httpRequest, InetSocketAddress remoteAddress) {
        HttpResponse httpResponse = HttpResponse.notFoundResponse();
        HttpRequest filteredRequest = this.filters.applyOnRequestFilters(httpRequest);
        if (filteredRequest != null) {
            httpResponse = this.filters.applyOnResponseFilters(httpRequest, this.httpClient.sendRequest(filteredRequest, remoteAddress));
            if (httpResponse == null) {
                httpResponse = HttpResponse.notFoundResponse();
            }
            this.logFormatter.infoLog("returning response:{}" + Character.NEW_LINE + " for request as json:{}" + Character.NEW_LINE + " as curl:{}", new Object[]{httpResponse, httpRequest, this.httpRequestToCurlSerializer.toCurl(httpRequest, remoteAddress)});
        }
        return httpResponse;
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(ctx, request, responseStatus, "", "application/json");
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        HttpResponse response = HttpResponse.response().withStatusCode(Integer.valueOf(responseStatus.code())).withBody(body);
        if (body != null && !body.isEmpty()) {
            response.updateHeader(Header.header((String)HttpHeaderNames.CONTENT_TYPE.toString(), (String[])new String[]{contentType + "; charset=utf-8"}));
        }
        if (ConfigurationProperties.enableCORSForAPI()) {
            this.addCORSHeaders.addCORSHeaders(response);
        }
        this.writeResponse(ctx, request, response);
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        if (ConfigurationProperties.enableCORSForAllResponses()) {
            this.addCORSHeaders.addCORSHeaders(response);
        }
        if (request.isKeepAlive() != null && request.isKeepAlive().booleanValue()) {
            response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.KEEP_ALIVE.toString()}));
            ctx.write((Object)response);
        } else {
            response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.CLOSE.toString()}));
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!Logging.shouldIgnoreException(cause)) {
            this.logger.warn("Exception caught by HTTP proxy handler -> closing pipeline " + ctx.channel(), cause);
        }
        ctx.close();
    }
}

