/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.stop;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.EventLoopGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.mockserver.stop.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopEventQueue {
    @VisibleForTesting
    protected final List<Stoppable> stoppables = new ArrayList<Stoppable>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Stoppable stoppable) {
        List<Stoppable> list = this.stoppables;
        synchronized (list) {
            this.stoppables.add(stoppable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Stoppable stoppable) {
        List<Stoppable> list = this.stoppables;
        synchronized (list) {
            this.stoppables.remove(stoppable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<Stoppable> list = this.stoppables;
        synchronized (list) {
            this.stoppables.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> stopOthers(Stoppable currentStoppable) {
        this.unregister(currentStoppable);
        SettableFuture stopped = SettableFuture.create();
        try {
            List<Stoppable> list = this.stoppables;
            synchronized (list) {
                for (Stoppable stoppable : new ArrayList<Stoppable>(this.stoppables)) {
                    Future<?> future = stoppable.stop();
                    if (future != null) {
                        future.get();
                    }
                    this.unregister(stoppable);
                }
            }
            stopped.set((Object)"stopped");
        }
        catch (Exception e) {
            stopped.setException((Throwable)e);
        }
        return stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> stop(Stoppable currentStoppable, SettableFuture<String> stopping, EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        bossGroup.shutdownGracefully();
        workerGroup.shutdownGracefully();
        try {
            bossGroup.terminationFuture().sync();
            workerGroup.terminationFuture().sync();
        }
        catch (InterruptedException e) {
        }
        finally {
            try {
                this.stopOthers(currentStoppable).get();
            }
            catch (Exception ie) {}
            stopping.set((Object)"stopped");
        }
        return stopping;
    }
}

