/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client;

import com.google.common.annotations.VisibleForTesting;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.mockserver.client.ClientException;
import org.mockserver.client.MockServerClient;
import org.mockserver.client.MockServerEventBus;
import org.mockserver.closurecallback.websocketclient.WebSocketClient;
import org.mockserver.closurecallback.websocketclient.WebSocketException;
import org.mockserver.closurecallback.websocketregistry.LocalCallbackRegistry;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.action.ExpectationCallback;
import org.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import org.mockserver.mock.action.ExpectationForwardCallback;
import org.mockserver.mock.action.ExpectationResponseCallback;
import org.mockserver.model.Delay;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpMessage;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpOverrideForwardedRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpTemplate;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.uuid.UUIDService;

public class ForwardChainExpectation {
    private final MockServerLogger mockServerLogger;
    private final MockServerClient mockServerClient;
    private final Expectation expectation;
    private final MockServerEventBus mockServerEventBus;

    ForwardChainExpectation(MockServerLogger mockServerLogger, MockServerEventBus mockServerEventBus, MockServerClient mockServerClient, Expectation expectation) {
        this.mockServerLogger = mockServerLogger;
        this.mockServerEventBus = mockServerEventBus;
        this.mockServerClient = mockServerClient;
        this.expectation = expectation;
    }

    public Expectation[] respond(HttpResponse httpResponse) {
        this.expectation.thenRespond(httpResponse);
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] respond(HttpTemplate httpTemplate) {
        this.expectation.thenRespond(httpTemplate);
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] respond(HttpClassCallback httpClassCallback) {
        this.expectation.thenRespond(httpClassCallback);
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] respond(ExpectationResponseCallback expectationResponseCallback) {
        this.expectation.thenRespond(new HttpObjectCallback().withClientId(this.registerWebSocketClient(expectationResponseCallback, null)));
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] respond(ExpectationResponseCallback expectationResponseCallback, Delay delay) {
        this.expectation.thenRespond((HttpObjectCallback)new HttpObjectCallback().withClientId(this.registerWebSocketClient(expectationResponseCallback, null)).withDelay(delay));
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] forward(HttpForward httpForward) {
        this.expectation.thenForward(httpForward);
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] forward(HttpTemplate httpTemplate) {
        this.expectation.thenForward(httpTemplate);
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] forward(HttpClassCallback httpClassCallback) {
        this.expectation.thenForward(httpClassCallback);
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] forward(ExpectationForwardCallback expectationForwardCallback) {
        this.expectation.thenForward(new HttpObjectCallback().withClientId(this.registerWebSocketClient(expectationForwardCallback, null)));
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] forward(ExpectationForwardCallback expectationForwardCallback, ExpectationForwardAndResponseCallback expectationForwardResponseCallback) {
        this.expectation.thenForward(new HttpObjectCallback().withResponseCallback(true).withClientId(this.registerWebSocketClient(expectationForwardCallback, expectationForwardResponseCallback)));
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] forward(ExpectationForwardCallback expectationForwardCallback, Delay delay) {
        this.expectation.thenForward((HttpObjectCallback)new HttpObjectCallback().withClientId(this.registerWebSocketClient(expectationForwardCallback, null)).withDelay(delay));
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] forward(ExpectationForwardCallback expectationForwardCallback, ExpectationForwardAndResponseCallback expectationForwardResponseCallback, Delay delay) {
        this.expectation.thenForward((HttpObjectCallback)new HttpObjectCallback().withResponseCallback(true).withClientId(this.registerWebSocketClient(expectationForwardCallback, expectationForwardResponseCallback)).withDelay(delay));
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] forward(HttpOverrideForwardedRequest httpOverrideForwardedRequest) {
        this.expectation.thenForward(httpOverrideForwardedRequest);
        return this.mockServerClient.upsert(this.expectation);
    }

    public Expectation[] error(HttpError httpError) {
        this.expectation.thenError(httpError);
        return this.mockServerClient.upsert(this.expectation);
    }

    private <T extends HttpMessage> String registerWebSocketClient(ExpectationCallback<T> expectationCallback, ExpectationForwardAndResponseCallback expectationForwardResponseCallback) {
        try {
            String clientId = UUIDService.getUUID();
            LocalCallbackRegistry.registerCallback(clientId, expectationCallback);
            LocalCallbackRegistry.registerCallback(clientId, expectationForwardResponseCallback);
            WebSocketClient<T> webSocketClient = new WebSocketClient<T>(new NioEventLoopGroup(ConfigurationProperties.webSocketClientEventLoopThreadCount(), new Scheduler.SchedulerThreadFactory(WebSocketClient.class.getSimpleName() + "-eventLoop")), clientId, this.mockServerLogger);
            Future<String> register = webSocketClient.registerExpectationCallback(expectationCallback, expectationForwardResponseCallback, this.mockServerClient.remoteAddress(), this.mockServerClient.contextPath(), this.mockServerClient.isSecure());
            this.mockServerEventBus.subscribe(webSocketClient::stopClient, MockServerEventBus.EventType.STOP, MockServerEventBus.EventType.RESET);
            return register.get(ConfigurationProperties.maxFutureTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            if (e.getCause() instanceof WebSocketException) {
                throw new ClientException(e.getCause().getMessage(), e);
            }
            throw new ClientException("Unable to retrieve client registration id", e);
        }
    }

    @VisibleForTesting
    Expectation getExpectation() {
        return this.expectation;
    }
}

