/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.mockserver.client.HttpClientConnectionErrorHandler;
import org.mockserver.client.HttpClientHandler;
import org.mockserver.client.NettyHttpClient;
import org.mockserver.codec.MockServerBinaryClientCodec;
import org.mockserver.codec.MockServerHttpClientCodec;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.proxyconfiguration.ProxyConfiguration;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public class HttpClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final MockServerLogger mockServerLogger;
    private final boolean forwardProxyClient;
    private final boolean isHttp;
    private final HttpClientConnectionErrorHandler httpClientConnectionHandler;
    private final HttpClientHandler httpClientHandler;
    private final ProxyConfiguration proxyConfiguration;
    private final NettySslContextFactory nettySslContextFactory;

    HttpClientInitializer(ProxyConfiguration proxyConfiguration, MockServerLogger mockServerLogger, boolean forwardProxyClient, NettySslContextFactory nettySslContextFactory, boolean isHttp) {
        this.proxyConfiguration = proxyConfiguration;
        this.mockServerLogger = mockServerLogger;
        this.forwardProxyClient = forwardProxyClient;
        this.isHttp = isHttp;
        this.httpClientHandler = new HttpClientHandler();
        this.httpClientConnectionHandler = new HttpClientConnectionErrorHandler();
        this.nettySslContextFactory = nettySslContextFactory;
    }

    @Override
    public void initChannel(SocketChannel channel) {
        boolean secure;
        ChannelPipeline pipeline = channel.pipeline();
        boolean bl = secure = channel.attr(NettyHttpClient.SECURE) != null && channel.attr(NettyHttpClient.SECURE).get() != null && channel.attr(NettyHttpClient.SECURE).get() != false;
        if (this.proxyConfiguration != null) {
            if (this.proxyConfiguration.getType() == ProxyConfiguration.Type.HTTPS && secure) {
                if (this.proxyConfiguration.getUsername() != null && this.proxyConfiguration.getPassword() != null) {
                    pipeline.addLast(new HttpProxyHandler((SocketAddress)this.proxyConfiguration.getProxyAddress(), this.proxyConfiguration.getUsername(), this.proxyConfiguration.getPassword()));
                } else {
                    pipeline.addLast(new HttpProxyHandler(this.proxyConfiguration.getProxyAddress()));
                }
            } else if (this.proxyConfiguration.getType() == ProxyConfiguration.Type.SOCKS5) {
                if (this.proxyConfiguration.getUsername() != null && this.proxyConfiguration.getPassword() != null) {
                    pipeline.addLast(new Socks5ProxyHandler(this.proxyConfiguration.getProxyAddress(), this.proxyConfiguration.getUsername(), this.proxyConfiguration.getPassword()));
                } else {
                    pipeline.addLast(new Socks5ProxyHandler(this.proxyConfiguration.getProxyAddress()));
                }
            }
        }
        pipeline.addLast(this.httpClientConnectionHandler);
        if (secure) {
            InetSocketAddress remoteAddress = channel.attr(NettyHttpClient.REMOTE_SOCKET).get();
            pipeline.addLast(this.nettySslContextFactory.createClientSslContext(this.forwardProxyClient).newHandler(channel.alloc(), remoteAddress.getHostName(), remoteAddress.getPort()));
        }
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            pipeline.addLast(new LoggingHandler("NettyHttpClient -->"));
        }
        if (this.isHttp) {
            pipeline.addLast(new HttpClientCodec());
            pipeline.addLast(new HttpContentDecompressor());
            pipeline.addLast(new HttpObjectAggregator(Integer.MAX_VALUE));
            pipeline.addLast(new MockServerHttpClientCodec(this.mockServerLogger));
        } else {
            pipeline.addLast(new MockServerBinaryClientCodec());
        }
        pipeline.addLast(this.httpClientHandler);
    }
}

