/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.closurecallback.websocketregistry;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.Collections;
import java.util.Map;
import org.mockserver.closurecallback.websocketclient.WebSocketException;
import org.mockserver.closurecallback.websocketregistry.LocalCallbackRegistry;
import org.mockserver.closurecallback.websocketregistry.WebSocketRequestCallback;
import org.mockserver.closurecallback.websocketregistry.WebSocketResponseCallback;
import org.mockserver.collections.CircularHashMap;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.metrics.Metrics;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpRequestAndHttpResponse;
import org.mockserver.model.HttpResponse;
import org.mockserver.serialization.WebSocketMessageSerializer;
import org.mockserver.serialization.model.WebSocketClientIdDTO;
import org.mockserver.serialization.model.WebSocketErrorDTO;
import org.slf4j.event.Level;

public class WebSocketClientRegistry {
    public static final String WEB_SOCKET_CORRELATION_ID_HEADER_NAME = "WebSocketCorrelationId";
    private final MockServerLogger mockServerLogger;
    private final WebSocketMessageSerializer webSocketMessageSerializer;
    private final Map<String, Channel> clientRegistry = Collections.synchronizedMap(new CircularHashMap(ConfigurationProperties.maxWebSocketExpectations()));
    private final Map<String, WebSocketResponseCallback> responseCallbackRegistry = new CircularHashMap<String, WebSocketResponseCallback>(ConfigurationProperties.maxWebSocketExpectations());
    private final Map<String, WebSocketRequestCallback> forwardCallbackRegistry = new CircularHashMap<String, WebSocketRequestCallback>(ConfigurationProperties.maxWebSocketExpectations());

    public WebSocketClientRegistry(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.webSocketMessageSerializer = new WebSocketMessageSerializer(mockServerLogger);
    }

    void receivedTextWebSocketFrame(TextWebSocketFrame textWebSocketFrame) {
        block11: {
            try {
                Object deserializedMessage = this.webSocketMessageSerializer.deserialize(textWebSocketFrame.text());
                if (MockServerLogger.isEnabled(Level.TRACE)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("received message over websocket{}").setArguments(deserializedMessage));
                }
                if (deserializedMessage instanceof HttpResponse) {
                    HttpResponse httpResponse = (HttpResponse)deserializedMessage;
                    String firstHeader = httpResponse.getFirstHeader(WEB_SOCKET_CORRELATION_ID_HEADER_NAME);
                    WebSocketResponseCallback webSocketResponseCallback = this.responseCallbackRegistry.get(firstHeader);
                    if (webSocketResponseCallback != null) {
                        webSocketResponseCallback.handle(httpResponse);
                    }
                    break block11;
                }
                if (deserializedMessage instanceof HttpRequest) {
                    HttpRequest httpRequest = (HttpRequest)deserializedMessage;
                    String firstHeader = httpRequest.getFirstHeader(WEB_SOCKET_CORRELATION_ID_HEADER_NAME);
                    WebSocketRequestCallback webSocketRequestCallback = this.forwardCallbackRegistry.get(firstHeader);
                    if (webSocketRequestCallback != null) {
                        webSocketRequestCallback.handle(httpRequest);
                    }
                    break block11;
                }
                if (deserializedMessage instanceof WebSocketErrorDTO) {
                    WebSocketErrorDTO webSocketErrorDTO = (WebSocketErrorDTO)deserializedMessage;
                    if (this.forwardCallbackRegistry.containsKey(webSocketErrorDTO.getWebSocketCorrelationId())) {
                        this.forwardCallbackRegistry.get(webSocketErrorDTO.getWebSocketCorrelationId()).handleError(HttpResponse.response().withStatusCode(404).withBody(webSocketErrorDTO.getMessage()));
                    } else if (this.responseCallbackRegistry.containsKey(webSocketErrorDTO.getWebSocketCorrelationId())) {
                        this.responseCallbackRegistry.get(webSocketErrorDTO.getWebSocketCorrelationId()).handle(HttpResponse.response().withStatusCode(404).withBody(webSocketErrorDTO.getMessage()));
                    }
                    break block11;
                }
                throw new WebSocketException("Unsupported web socket message " + deserializedMessage);
            }
            catch (Exception e) {
                throw new WebSocketException("Exception while receiving web socket message" + textWebSocketFrame.text(), e);
            }
        }
    }

    public int size() {
        return this.clientRegistry.size();
    }

    void registerClient(String clientId, ChannelHandlerContext ctx) {
        try {
            ctx.channel().writeAndFlush(new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(new WebSocketClientIdDTO().setClientId(clientId))));
        }
        catch (Exception e) {
            throw new WebSocketException("Exception while sending web socket registration client id message to client " + clientId, e);
        }
        this.clientRegistry.put(clientId, ctx.channel());
        Metrics.set(Metrics.Name.WEBSOCKET_CALLBACK_CLIENT_COUNT, this.clientRegistry.size());
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("registering client " + clientId + ""));
        }
    }

    public void unregisterClient(String clientId) {
        LocalCallbackRegistry.unregisterCallback(clientId);
        Channel removeChannel = this.clientRegistry.remove(clientId);
        if (removeChannel != null && removeChannel.isOpen()) {
            removeChannel.close();
        }
        Metrics.set(Metrics.Name.WEBSOCKET_CALLBACK_CLIENT_COUNT, this.clientRegistry.size());
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("unregistering client " + clientId + ""));
        }
    }

    public void registerResponseCallbackHandler(String webSocketCorrelationId, WebSocketResponseCallback expectationResponseCallback) {
        this.responseCallbackRegistry.put(webSocketCorrelationId, expectationResponseCallback);
        Metrics.set(Metrics.Name.WEBSOCKET_CALLBACK_RESPONSE_HANDLER_COUNT, this.responseCallbackRegistry.size());
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("registering response callback " + webSocketCorrelationId));
        }
    }

    public void unregisterResponseCallbackHandler(String webSocketCorrelationId) {
        this.responseCallbackRegistry.remove(webSocketCorrelationId);
        Metrics.set(Metrics.Name.WEBSOCKET_CALLBACK_RESPONSE_HANDLER_COUNT, this.responseCallbackRegistry.size());
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("unregistering response callback " + webSocketCorrelationId + ""));
        }
    }

    public void registerForwardCallbackHandler(String webSocketCorrelationId, WebSocketRequestCallback expectationForwardCallback) {
        this.forwardCallbackRegistry.put(webSocketCorrelationId, expectationForwardCallback);
        Metrics.set(Metrics.Name.WEBSOCKET_CALLBACK_FORWARD_HANDLER_COUNT, this.forwardCallbackRegistry.size());
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("registering forward callback " + webSocketCorrelationId));
        }
    }

    public void unregisterForwardCallbackHandler(String webSocketCorrelationId) {
        this.forwardCallbackRegistry.remove(webSocketCorrelationId);
        Metrics.set(Metrics.Name.WEBSOCKET_CALLBACK_FORWARD_HANDLER_COUNT, this.forwardCallbackRegistry.size());
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("unregistering forward callback " + webSocketCorrelationId + ""));
        }
    }

    public boolean sendClientMessage(String clientId, HttpRequest httpRequest, HttpResponse httpResponse) {
        try {
            if (this.clientRegistry.containsKey(clientId)) {
                if (httpResponse == null) {
                    if (MockServerLogger.isEnabled(Level.TRACE)) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(httpRequest).setMessageFormat("sending message{}to client " + clientId).setArguments(httpRequest));
                    }
                    this.clientRegistry.get(clientId).writeAndFlush(new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(httpRequest)));
                } else {
                    HttpRequestAndHttpResponse httpRequestAndHttpResponse = new HttpRequestAndHttpResponse().withHttpRequest(httpRequest).withHttpResponse(httpResponse);
                    if (MockServerLogger.isEnabled(Level.TRACE)) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(httpRequest).setMessageFormat("sending message{}to client " + clientId + "").setArguments(httpRequestAndHttpResponse));
                    }
                    this.clientRegistry.get(clientId).writeAndFlush(new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(httpRequestAndHttpResponse)));
                }
                return true;
            }
            if (MockServerLogger.isEnabled(Level.WARN)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setHttpRequest(httpRequest).setMessageFormat("client " + clientId + " not found for request{}client registry only contains{}").setArguments(httpRequest, this.clientRegistry));
            }
            return false;
        }
        catch (Exception e) {
            throw new WebSocketException("Exception while sending web socket message " + httpRequest + " to client " + clientId, e);
        }
    }

    public synchronized void reset() {
        this.forwardCallbackRegistry.clear();
        this.responseCallbackRegistry.clear();
        this.clientRegistry.forEach((clientId, channel) -> {
            LocalCallbackRegistry.unregisterCallback(clientId);
            channel.close();
        });
        this.clientRegistry.clear();
        Metrics.clearWebSocketMetrics();
    }
}

