/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.dashboard;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public class DashboardHandler {
    private static final Map<String, String> MIME_MAP = new HashMap<String, String>();
    private static final List<String> IS_STRING_CONTENT = ImmutableList.of("css", "js", "map", "json", "html");

    public DashboardHandler() {
        MIME_MAP.put("css", "text/css; charset=utf-8");
        MIME_MAP.put("js", "application/javascript; charset=UTF-8");
        MIME_MAP.put("map", "application/json; charset=UTF-8");
        MIME_MAP.put("json", "application/json; charset=UTF-8");
        MIME_MAP.put("html", "text/html; charset=utf-8");
        MIME_MAP.put("ico", "image/x-icon");
        MIME_MAP.put("woff2", "application/font-woff2");
        MIME_MAP.put("ttf", "application/octet-stream");
        MIME_MAP.put("png", "image/png");
    }

    public void renderDashboard(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        HttpResponse response = HttpResponse.notFoundResponse();
        if (request.getMethod().getValue().equals("GET")) {
            InputStream contentStream;
            String path = StringUtils.substringAfter(request.getPath().getValue(), "/mockserver/dashboard");
            if (path.isEmpty() || path.equals("/")) {
                path = "/index.html";
            }
            if ((contentStream = DashboardHandler.class.getResourceAsStream("/org/mockserver/dashboard" + path)) != null) {
                String extension = StringUtils.substringAfterLast(path, ".");
                if (IS_STRING_CONTENT.contains(extension)) {
                    String content = new String(ByteStreams.toByteArray(contentStream), StandardCharsets.UTF_8.name());
                    response = HttpResponse.response().withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), MIME_MAP.get(extension)).withHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(content.getBytes().length)).withBody(content);
                } else {
                    byte[] bytes = ByteStreams.toByteArray(contentStream);
                    response = HttpResponse.response().withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), MIME_MAP.get(extension)).withHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(bytes.length)).withBody(bytes);
                }
                if (request.isKeepAlive().booleanValue()) {
                    response.withHeader(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.KEEP_ALIVE.toString());
                }
            }
        }
        if (!request.isKeepAlive().booleanValue()) {
            ctx.writeAndFlush(response).addListener(ChannelFutureListener.CLOSE);
        } else {
            ctx.writeAndFlush(response);
        }
    }
}

