/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.dashboard.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mockserver.dashboard.serializers.Description;
import org.mockserver.log.model.LogEntry;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.ObjectWithJsonToString;
import org.mockserver.model.RequestDefinition;

public class DashboardLogEntryDTO
extends ObjectWithJsonToString {
    private static final String[] EXCLUDED_FIELDS = new String[]{"id", "timestamp"};
    private String id;
    private String correlationId;
    private String timestamp;
    private LogEntry.LogMessageType type;
    private RequestDefinition[] httpRequests;
    private HttpResponse httpResponse;
    private Map<String, String> style;
    private String messageFormat;
    private Object[] arguments;
    private String[] throwable;
    private String because;
    private Description description;

    public DashboardLogEntryDTO(String id, String correlationId, String timestamp, LogEntry.LogMessageType type) {
        this.setId(id);
        this.setCorrelationId(correlationId);
        this.setTimestamp(timestamp);
        this.setType(type);
    }

    public DashboardLogEntryDTO(LogEntry logEntry) {
        this.setId(logEntry.id());
        this.setCorrelationId(logEntry.getCorrelationId());
        this.setTimestamp(logEntry.getTimestamp());
        this.setType(logEntry.getType());
        this.setHttpRequests(logEntry.getHttpUpdatedRequests());
        this.setHttpResponse(logEntry.getHttpUpdatedResponse());
        this.setMessageFormat(logEntry.getMessageFormat());
        this.setArguments(logEntry.getArguments());
        if (logEntry.getThrowable() != null) {
            this.setThrowable(ExceptionUtils.getStackTrace(logEntry.getThrowable()).split(System.lineSeparator()));
        }
        this.setBecause(logEntry.getBecause());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public LogEntry.LogMessageType getType() {
        return this.type;
    }

    public DashboardLogEntryDTO setType(LogEntry.LogMessageType type) {
        this.type = type;
        return this;
    }

    @JsonIgnore
    public RequestDefinition[] getHttpRequests() {
        return this.httpRequests;
    }

    public DashboardLogEntryDTO setHttpRequests(RequestDefinition[] httpRequests) {
        this.httpRequests = httpRequests;
        return this;
    }

    public RequestDefinition getHttpRequest() {
        if (this.httpRequests != null && this.httpRequests.length > 0) {
            return this.httpRequests[0];
        }
        return null;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public DashboardLogEntryDTO setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }

    public Map<String, String> getStyle() {
        return this.style;
    }

    public DashboardLogEntryDTO setStyle(Map<String, String> style) {
        this.style = style;
        return this;
    }

    public String getMessageFormat() {
        return this.messageFormat;
    }

    public DashboardLogEntryDTO setMessageFormat(String messageFormat) {
        this.messageFormat = messageFormat;
        return this;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public DashboardLogEntryDTO setArguments(Object ... arguments) {
        this.arguments = arguments;
        return this;
    }

    public String[] getThrowable() {
        return this.throwable;
    }

    public void setThrowable(String[] throwable) {
        this.throwable = throwable;
    }

    @JsonIgnore
    public Object getBecause() {
        return this.because;
    }

    public DashboardLogEntryDTO setBecause(String because) {
        this.because = because;
        return this;
    }

    public Description getDescription() {
        return this.description;
    }

    public DashboardLogEntryDTO setDescription(Description description) {
        this.description = description;
        return this;
    }

    @Override
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

