/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.Options;
import net.javacrumbs.jsonunit.core.listener.DifferenceContext;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.MatchType;
import org.mockserver.serialization.ObjectMapperFactory;

public class JsonStringMatcher
extends BodyMatcher<String> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger"};
    private static final ObjectWriter PRETTY_PRINTER = ObjectMapperFactory.createObjectMapper(true, new JsonSerializer[0]);
    private final MockServerLogger mockServerLogger;
    private final String matcher;
    private JsonNode matcherJsonNode;
    private final MatchType matchType;

    JsonStringMatcher(MockServerLogger mockServerLogger, String matcher, MatchType matchType) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
        this.matchType = matchType;
    }

    @Override
    public boolean matches(MatchDifference context, String matched) {
        boolean result;
        block13: {
            result = false;
            try {
                Difference diffListener;
                block14: {
                    if (StringUtils.isBlank(this.matcher)) {
                        result = true;
                        break block13;
                    }
                    Options options = Options.empty();
                    switch (this.matchType) {
                        case STRICT: {
                            break;
                        }
                        case ONLY_MATCHING_FIELDS: {
                            options = options.with(Option.IGNORING_ARRAY_ORDER, Option.IGNORING_EXTRA_ARRAY_ITEMS, Option.IGNORING_EXTRA_FIELDS);
                        }
                    }
                    diffListener = new Difference();
                    Configuration diffConfig = Configuration.empty().withDifferenceListener(diffListener).withOptions(options);
                    try {
                        if (this.matcherJsonNode == null) {
                            this.matcherJsonNode = ObjectMapperFactory.createObjectMapper().readTree(this.matcher);
                        }
                        result = Diff.create((Object)this.matcherJsonNode, (Object)ObjectMapperFactory.createObjectMapper().readTree(matched), "", "", diffConfig).similar();
                    }
                    catch (Throwable throwable) {
                        if (context == null) break block14;
                        context.addDifference(this.mockServerLogger, throwable, "exception while perform json match failed expected:{}found:{}", this.matcher, matched);
                    }
                }
                if (!result && context != null) {
                    if (diffListener.differences.isEmpty()) {
                        context.addDifference(this.mockServerLogger, "json match failed expected:{}found:{}", this.matcher, matched);
                    } else {
                        context.addDifference(this.mockServerLogger, "json match failed expected:{}found:{}failed because:{}", this.matcher, matched, Joiner.on("," + Character.NEW_LINE).join(diffListener.differences));
                    }
                }
            }
            catch (Throwable throwable) {
                if (context == null) break block13;
                context.addDifference(this.mockServerLogger, throwable, "json match failed expected:{}found:{}failed because:{}", this.matcher, matched, throwable.getMessage());
            }
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return StringUtils.isBlank(this.matcher);
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }

    private static class Difference
    implements DifferenceListener {
        public List<String> differences = new ArrayList<String>();

        private Difference() {
        }

        @Override
        public void diff(net.javacrumbs.jsonunit.core.listener.Difference difference, DifferenceContext context) {
            switch (difference.getType()) {
                case EXTRA: {
                    this.differences.add("additional element at \"" + difference.getActualPath() + "\" with value: " + this.prettyPrint(difference.getActual()));
                    break;
                }
                case MISSING: {
                    this.differences.add("missing element at \"" + difference.getActualPath() + "\"");
                    break;
                }
                case DIFFERENT: {
                    this.differences.add("wrong value at \"" + difference.getActualPath() + "\", expected: " + this.prettyPrint(difference.getExpected()) + " but was: " + this.prettyPrint(difference.getActual()));
                }
            }
        }

        private String prettyPrint(Object value) {
            try {
                return PRETTY_PRINTER.writeValueAsString(value);
            }
            catch (JsonProcessingException e) {
                return String.valueOf(value);
            }
        }
    }
}

