/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.closurecallback.websocketregistry.WebSocketClientRegistry;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.MockServerEventLog;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.memory.MemoryMonitoring;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.OpenAPIExpectation;
import org.mockserver.mock.RequestMatchers;
import org.mockserver.mock.listeners.MockServerMatcherNotifier;
import org.mockserver.model.Action;
import org.mockserver.model.ClearType;
import org.mockserver.model.Format;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.LogEventRequestAndResponse;
import org.mockserver.model.MediaType;
import org.mockserver.model.RequestDefinition;
import org.mockserver.model.RetrieveType;
import org.mockserver.openapi.OpenAPIConverter;
import org.mockserver.persistence.ExpectationFileSystemPersistence;
import org.mockserver.persistence.ExpectationFileWatcher;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.serialization.ExpectationSerializer;
import org.mockserver.serialization.LogEntrySerializer;
import org.mockserver.serialization.LogEventRequestAndResponseSerializer;
import org.mockserver.serialization.OpenAPIExpectationSerializer;
import org.mockserver.serialization.RequestDefinitionSerializer;
import org.mockserver.serialization.VerificationSequenceSerializer;
import org.mockserver.serialization.VerificationSerializer;
import org.mockserver.serialization.java.ExpectationToJavaSerializer;
import org.mockserver.server.initialize.ExpectationInitializerLoader;
import org.mockserver.uuid.UUIDService;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.event.Level;

public class HttpState {
    public static final String LOG_SEPARATOR = Character.NEW_LINE + "------------------------------------" + Character.NEW_LINE;
    public static final String PATH_PREFIX = "/mockserver";
    private static final ThreadLocal<Integer> LOCAL_PORT = new ThreadLocal();
    private final String uniqueLoopPreventionHeaderValue = "MockServer_" + UUIDService.getUUID();
    private final MockServerEventLog mockServerLog;
    private final Scheduler scheduler;
    private ExpectationFileSystemPersistence expectationFileSystemPersistence;
    private ExpectationFileWatcher expectationFileWatcher;
    private RequestMatchers requestMatchers;
    private MockServerLogger mockServerLogger;
    private WebSocketClientRegistry webSocketClientRegistry;
    private RequestDefinitionSerializer requestDefinitionSerializer;
    private LogEventRequestAndResponseSerializer httpRequestResponseSerializer;
    private ExpectationSerializer expectationSerializer;
    private OpenAPIExpectationSerializer openAPIExpectationSerializer;
    private ExpectationToJavaSerializer expectationToJavaSerializer;
    private VerificationSerializer verificationSerializer;
    private VerificationSequenceSerializer verificationSequenceSerializer;
    private LogEntrySerializer logEntrySerializer;
    private MemoryMonitoring memoryMonitoring;
    private OpenAPIConverter openAPIConverter;

    public static void setPort(HttpRequest request) {
        if (request != null && request.getSocketAddress() != null) {
            HttpState.setPort(request.getSocketAddress().getPort());
            request.withSocketAddress(null);
        }
    }

    public static void setPort(Integer port) {
        LOCAL_PORT.set(port);
    }

    public static void setPort(Integer ... port) {
        if (port != null && port.length > 0) {
            HttpState.setPort(port[0]);
        }
    }

    public static void setPort(List<Integer> port) {
        if (port != null && port.size() > 0) {
            HttpState.setPort(port.get(0));
        }
    }

    public static Integer getPort() {
        return LOCAL_PORT.get();
    }

    public HttpState(MockServerLogger mockServerLogger, Scheduler scheduler) {
        this.mockServerLogger = mockServerLogger.setHttpStateHandler(this);
        this.scheduler = scheduler;
        this.webSocketClientRegistry = new WebSocketClientRegistry(mockServerLogger);
        this.mockServerLog = new MockServerEventLog(mockServerLogger, scheduler, true);
        this.requestMatchers = new RequestMatchers(mockServerLogger, scheduler, this.webSocketClientRegistry);
        if (ConfigurationProperties.persistExpectations()) {
            this.expectationFileSystemPersistence = new ExpectationFileSystemPersistence(mockServerLogger, this.requestMatchers);
        }
        if (ConfigurationProperties.watchInitializationJson()) {
            this.expectationFileWatcher = new ExpectationFileWatcher(mockServerLogger, this.requestMatchers);
        }
        this.memoryMonitoring = new MemoryMonitoring(this.mockServerLog, this.requestMatchers);
        new ExpectationInitializerLoader(mockServerLogger, this.requestMatchers);
    }

    public MockServerLogger getMockServerLogger() {
        return this.mockServerLogger;
    }

    public void clear(HttpRequest request) {
        String logCorrelationId = UUIDService.getUUID();
        RequestDefinition requestDefinition = null;
        if (StringUtils.isNotBlank(request.getBodyAsString())) {
            requestDefinition = this.getRequestDefinitionSerializer().deserialize(request.getBodyAsJsonOrXmlString());
            requestDefinition.withLogCorrelationId(logCorrelationId);
        }
        try {
            ClearType type = ClearType.valueOf(StringUtils.defaultIfEmpty(request.getFirstQueryStringParameter("type").toUpperCase(), "ALL"));
            switch (type) {
                case LOG: {
                    this.mockServerLog.clear(requestDefinition);
                    break;
                }
                case EXPECTATIONS: {
                    this.requestMatchers.clear(requestDefinition);
                    break;
                }
                case ALL: {
                    this.mockServerLog.clear(requestDefinition);
                    this.requestMatchers.clear(requestDefinition);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setCorrelationId(logCorrelationId).setMessageFormat("exception handling request:{}error:{}").setArguments(request, iae.getMessage()).setThrowable(iae));
            throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("type") + "\" is not a valid value for \"type\" parameter, only the following values are supported " + Arrays.stream(ClearType.values()).map(input -> input.name().toLowerCase()).collect(Collectors.toList()));
        }
        System.gc();
    }

    public void reset() {
        this.requestMatchers.reset();
        this.mockServerLog.reset();
        this.webSocketClientRegistry.reset();
        if (MockServerLogger.isEnabled(Level.INFO)) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.CLEARED).setLogLevel(Level.INFO).setHttpRequest(HttpRequest.request()).setMessageFormat("resetting all expectations and request logs"));
        }
        System.gc();
        new Scheduler.SchedulerThreadFactory("MockServer Memory Metrics").newThread(() -> {
            try {
                TimeUnit.SECONDS.sleep(10L);
                this.memoryMonitoring.logMemoryMetrics();
            }
            catch (InterruptedException ie) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception handling reset request:{}").setArguments(ie.getMessage()).setThrowable(ie));
                ie.printStackTrace();
            }
        });
    }

    public List<Expectation> add(OpenAPIExpectation openAPIExpectation) {
        return this.getOpenAPIConverter().buildExpectations(openAPIExpectation.getSpecUrlOrPayload(), openAPIExpectation.getOperationsAndResponses()).stream().map(xva$0 -> this.add((Expectation)xva$0)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Expectation> add(Expectation ... expectations) {
        ArrayList<Expectation> upsertedExpectations = new ArrayList<Expectation>();
        for (Expectation expectation : expectations) {
            String hostHeader;
            RequestDefinition requestDefinition = expectation.getHttpRequest();
            if (requestDefinition instanceof HttpRequest && StringUtils.isNotBlank(hostHeader = ((HttpRequest)requestDefinition).getFirstHeader(HttpHeaderNames.HOST.toString()))) {
                this.scheduler.submit(() -> ConfigurationProperties.addSubjectAlternativeName(hostHeader));
            }
            upsertedExpectations.add(this.requestMatchers.add(expectation, MockServerMatcherNotifier.Cause.API));
        }
        return upsertedExpectations;
    }

    public Expectation firstMatchingExpectation(HttpRequest request) {
        if (this.requestMatchers.isEmpty()) {
            return null;
        }
        return this.requestMatchers.firstMatchingExpectation(request);
    }

    public void postProcess(Expectation expectation) {
        this.requestMatchers.postProcess(expectation);
    }

    public void log(LogEntry logEntry) {
        if (this.mockServerLog != null) {
            this.mockServerLog.add(logEntry);
        }
    }

    public HttpResponse retrieve(HttpRequest request) {
        String logCorrelationId = UUIDService.getUUID();
        CompletableFuture<HttpResponse> httpResponseFuture = new CompletableFuture<HttpResponse>();
        HttpResponse response = HttpResponse.response().withStatusCode(HttpResponseStatus.OK.code());
        if (request != null) {
            try {
                HttpRequest requestDefinition = StringUtils.isNotBlank(request.getBodyAsString()) ? this.getRequestDefinitionSerializer().deserialize(request.getBodyAsJsonOrXmlString()) : HttpRequest.request();
                requestDefinition.withLogCorrelationId(logCorrelationId);
                Format format = Format.valueOf(StringUtils.defaultIfEmpty(request.getFirstQueryStringParameter("format").toUpperCase(), "JSON"));
                RetrieveType type = RetrieveType.valueOf(StringUtils.defaultIfEmpty(request.getFirstQueryStringParameter("type").toUpperCase(), "REQUESTS"));
                switch (type) {
                    case LOGS: {
                        this.mockServerLog.retrieveMessageLogEntries(requestDefinition, logEntries -> {
                            StringBuilder stringBuffer = new StringBuilder();
                            for (int i = 0; i < logEntries.size(); ++i) {
                                LogEntry messageLogEntry = (LogEntry)logEntries.get(i);
                                stringBuffer.append(messageLogEntry.getTimestamp()).append(" - ").append(messageLogEntry.getMessage());
                                if (i >= logEntries.size() - 1) continue;
                                stringBuffer.append(LOG_SEPARATOR);
                            }
                            stringBuffer.append(Character.NEW_LINE);
                            response.withBody(stringBuffer.toString(), MediaType.PLAIN_TEXT_UTF_8);
                            if (MockServerLogger.isEnabled(Level.INFO)) {
                                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.RETRIEVED).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setHttpRequest(requestDefinition).setMessageFormat("retrieved logs that match:{}").setArguments(requestDefinition));
                            }
                            httpResponseFuture.complete(response);
                        });
                        break;
                    }
                    case REQUESTS: {
                        LogEntry logEntry = new LogEntry().setType(LogEntry.LogMessageType.RETRIEVED).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setHttpRequest(requestDefinition).setMessageFormat("retrieved requests in " + format.name().toLowerCase() + " that match:{}").setArguments(requestDefinition);
                        switch (format) {
                            case JAVA: {
                                this.mockServerLog.retrieveRequests(requestDefinition, requests -> {
                                    response.withBody(this.getRequestDefinitionSerializer().serialize((List<? extends RequestDefinition>)requests), MediaType.create("application", "java").withCharset(StandardCharsets.UTF_8));
                                    this.mockServerLogger.logEvent(logEntry);
                                    httpResponseFuture.complete(response);
                                });
                                break;
                            }
                            case JSON: {
                                this.mockServerLog.retrieveRequests(requestDefinition, requests -> {
                                    response.withBody(this.getRequestDefinitionSerializer().serialize(true, (List<? extends RequestDefinition>)requests), MediaType.JSON_UTF_8);
                                    this.mockServerLogger.logEvent(logEntry);
                                    httpResponseFuture.complete(response);
                                });
                                break;
                            }
                            case LOG_ENTRIES: {
                                this.mockServerLog.retrieveRequestLogEntries(requestDefinition, logEntries -> {
                                    response.withBody(this.getLogEntrySerializer().serialize((List<LogEntry>)logEntries), MediaType.JSON_UTF_8);
                                    this.mockServerLogger.logEvent(logEntry);
                                    httpResponseFuture.complete(response);
                                });
                            }
                        }
                        break;
                    }
                    case REQUEST_RESPONSES: {
                        LogEntry logEntry = new LogEntry().setType(LogEntry.LogMessageType.RETRIEVED).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setHttpRequest(requestDefinition).setMessageFormat("retrieved requests and responses in " + format.name().toLowerCase() + " that match:{}").setArguments(requestDefinition);
                        switch (format) {
                            case JAVA: {
                                response.withBody("JAVA not supported for REQUEST_RESPONSES", MediaType.create("text", "plain").withCharset(StandardCharsets.UTF_8));
                                this.mockServerLogger.logEvent(logEntry);
                                httpResponseFuture.complete(response);
                                break;
                            }
                            case JSON: {
                                this.mockServerLog.retrieveRequestResponses(requestDefinition, httpRequestAndHttpResponses -> {
                                    response.withBody(this.getHttpRequestResponseSerializer().serialize((List<LogEventRequestAndResponse>)httpRequestAndHttpResponses), MediaType.JSON_UTF_8);
                                    this.mockServerLogger.logEvent(logEntry);
                                    httpResponseFuture.complete(response);
                                });
                                break;
                            }
                            case LOG_ENTRIES: {
                                this.mockServerLog.retrieveRequestResponseMessageLogEntries(requestDefinition, logEntries -> {
                                    response.withBody(this.getLogEntrySerializer().serialize((List<LogEntry>)logEntries), MediaType.JSON_UTF_8);
                                    this.mockServerLogger.logEvent(logEntry);
                                    httpResponseFuture.complete(response);
                                });
                            }
                        }
                        break;
                    }
                    case RECORDED_EXPECTATIONS: {
                        LogEntry logEntry = new LogEntry().setType(LogEntry.LogMessageType.RETRIEVED).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setHttpRequest(requestDefinition).setMessageFormat("retrieved recorded expectations in " + format.name().toLowerCase() + " that match:{}").setArguments(requestDefinition);
                        switch (format) {
                            case JAVA: {
                                this.mockServerLog.retrieveRecordedExpectations(requestDefinition, requests -> {
                                    response.withBody(this.getExpectationToJavaSerializer().serialize((List<Expectation>)requests), MediaType.create("application", "java").withCharset(StandardCharsets.UTF_8));
                                    this.mockServerLogger.logEvent(logEntry);
                                    httpResponseFuture.complete(response);
                                });
                                break;
                            }
                            case JSON: {
                                this.mockServerLog.retrieveRecordedExpectations(requestDefinition, requests -> {
                                    response.withBody(this.getExpectationSerializer().serialize((List<Expectation>)requests), MediaType.JSON_UTF_8);
                                    this.mockServerLogger.logEvent(logEntry);
                                    httpResponseFuture.complete(response);
                                });
                                break;
                            }
                            case LOG_ENTRIES: {
                                this.mockServerLog.retrieveRecordedExpectationLogEntries(requestDefinition, logEntries -> {
                                    response.withBody(this.getLogEntrySerializer().serialize((List<LogEntry>)logEntries), MediaType.JSON_UTF_8);
                                    this.mockServerLogger.logEvent(logEntry);
                                    httpResponseFuture.complete(response);
                                });
                            }
                        }
                        break;
                    }
                    case ACTIVE_EXPECTATIONS: {
                        List<Expectation> expectations = this.requestMatchers.retrieveActiveExpectations(requestDefinition);
                        switch (format) {
                            case JAVA: {
                                response.withBody(this.getExpectationToJavaSerializer().serialize(expectations), MediaType.create("application", "java").withCharset(StandardCharsets.UTF_8));
                                break;
                            }
                            case JSON: {
                                response.withBody(this.getExpectationSerializer().serialize(expectations), MediaType.JSON_UTF_8);
                                break;
                            }
                            case LOG_ENTRIES: {
                                response.withBody("LOG_ENTRIES not supported for ACTIVE_EXPECTATIONS", MediaType.create("text", "plain").withCharset(StandardCharsets.UTF_8));
                            }
                        }
                        if (MockServerLogger.isEnabled(Level.INFO)) {
                            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.RETRIEVED).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setHttpRequest(requestDefinition).setMessageFormat("retrieved active expectations in " + format.name().toLowerCase() + " that match:{}").setArguments(requestDefinition));
                        }
                        httpResponseFuture.complete(response);
                        break;
                    }
                }
                try {
                    return (HttpResponse)httpResponseFuture.get(ConfigurationProperties.maxFutureTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException ex) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setCorrelationId(logCorrelationId).setMessageFormat("exception handling request:{}error:{}").setArguments(request, ex.getMessage()).setThrowable(ex));
                    throw new RuntimeException("Exception retrieving state for " + request, ex);
                }
            }
            catch (IllegalArgumentException iae) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setCorrelationId(logCorrelationId).setMessageFormat("exception handling request:{}error:{}").setArguments(request, iae.getMessage()).setThrowable(iae));
                if (iae.getMessage().contains(RetrieveType.class.getSimpleName())) {
                    throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("type") + "\" is not a valid value for \"type\" parameter, only the following values are supported " + Arrays.stream(RetrieveType.values()).map(input -> input.name().toLowerCase()).collect(Collectors.toList()));
                }
                throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("format") + "\" is not a valid value for \"format\" parameter, only the following values are supported " + Arrays.stream(Format.values()).map(input -> input.name().toLowerCase()).collect(Collectors.toList()));
            }
        }
        return HttpResponse.response().withStatusCode(200);
    }

    public Future<String> verify(Verification verification) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        this.verify(verification, result::complete);
        return result;
    }

    public void verify(Verification verification, Consumer<String> resultConsumer) {
        this.mockServerLog.verify(verification, resultConsumer);
    }

    public Future<String> verify(VerificationSequence verification) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        this.verify(verification, result::complete);
        return result;
    }

    public void verify(VerificationSequence verification, Consumer<String> resultConsumer) {
        this.mockServerLog.verify(verification, resultConsumer);
    }

    public boolean handle(HttpRequest request, ResponseWriter responseWriter, boolean warDeployment) {
        request.withLogCorrelationId(UUIDService.getUUID());
        HttpState.setPort(request);
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(request).setMessageFormat("received request:{}").setArguments(request));
        }
        if (request.matches("PUT")) {
            ArrayList<Expectation> upsertedExpectations;
            CompletableFuture<Boolean> canHandle = new CompletableFuture<Boolean>();
            if (request.matches("PUT", "/mockserver/expectation", "/expectation")) {
                upsertedExpectations = new ArrayList<Expectation>();
                for (Expectation expectation : this.getExpectationSerializer().deserializeArray(request.getBodyAsJsonOrXmlString(), false)) {
                    if (warDeployment && !this.validateSupportedFeatures(expectation, request, responseWriter)) continue;
                    upsertedExpectations.addAll(this.add(expectation));
                }
                responseWriter.writeResponse(request, HttpResponse.response().withStatusCode(HttpResponseStatus.CREATED.code()).withBody(this.getExpectationSerializer().serialize((List<Expectation>)upsertedExpectations), MediaType.JSON_UTF_8), true);
                canHandle.complete(true);
            } else if (request.matches("PUT", "/mockserver/openapi", "/openapi")) {
                try {
                    upsertedExpectations = new ArrayList();
                    for (OpenAPIExpectation openAPIExpectation : this.getOpenAPIExpectationSerializer().deserializeArray(request.getBodyAsJsonOrXmlString(), false)) {
                        upsertedExpectations.addAll(this.add(openAPIExpectation));
                    }
                    responseWriter.writeResponse(request, HttpResponse.response().withStatusCode(HttpResponseStatus.CREATED.code()).withBody(this.getExpectationSerializer().serialize((List<Expectation>)upsertedExpectations), MediaType.JSON_UTF_8), true);
                }
                catch (IllegalArgumentException iae) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception handling request for open api expectation:{}error:{}").setArguments(request, iae.getMessage()).setThrowable(iae));
                    responseWriter.writeResponse(request, HttpResponseStatus.BAD_REQUEST, (!iae.getMessage().startsWith("Unable to load API spec") ? "Unable to load API spec" + (StringUtils.isNotBlank(iae.getMessage()) ? ", " : "") : "") + iae.getMessage(), MediaType.create("text", "plain").toString());
                }
                canHandle.complete(true);
            } else if (request.matches("PUT", "/mockserver/clear", "/clear")) {
                this.clear(request);
                responseWriter.writeResponse(request, HttpResponseStatus.OK);
                canHandle.complete(true);
            } else if (request.matches("PUT", "/mockserver/reset", "/reset")) {
                this.reset();
                responseWriter.writeResponse(request, HttpResponseStatus.OK);
                canHandle.complete(true);
            } else if (request.matches("PUT", "/mockserver/retrieve", "/retrieve")) {
                responseWriter.writeResponse(request, this.retrieve(request), true);
                canHandle.complete(true);
            } else if (request.matches("PUT", "/mockserver/verify", "/verify")) {
                this.verify(this.getVerificationSerializer().deserialize(request.getBodyAsJsonOrXmlString()), (String result) -> {
                    if (StringUtils.isEmpty(result)) {
                        responseWriter.writeResponse(request, HttpResponseStatus.ACCEPTED);
                    } else {
                        responseWriter.writeResponse(request, HttpResponseStatus.NOT_ACCEPTABLE, (String)result, MediaType.create("text", "plain").toString());
                    }
                    canHandle.complete(true);
                });
            } else if (request.matches("PUT", "/mockserver/verifySequence", "/verifySequence")) {
                this.verify(this.getVerificationSequenceSerializer().deserialize(request.getBodyAsJsonOrXmlString()), (String result) -> {
                    if (StringUtils.isEmpty(result)) {
                        responseWriter.writeResponse(request, HttpResponseStatus.ACCEPTED);
                    } else {
                        responseWriter.writeResponse(request, HttpResponseStatus.NOT_ACCEPTABLE, (String)result, MediaType.create("text", "plain").toString());
                    }
                    canHandle.complete(true);
                });
            } else {
                canHandle.complete(false);
            }
            try {
                return (Boolean)canHandle.get(ConfigurationProperties.maxFutureTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception handling request:{}error:{}").setArguments(request, ex.getMessage()).setThrowable(ex));
                return false;
            }
        }
        return false;
    }

    private boolean validateSupportedFeatures(Expectation expectation, HttpRequest request, ResponseWriter responseWriter) {
        boolean valid = true;
        Action action = expectation.getAction();
        String NOT_SUPPORTED_MESSAGE = " is not supported by MockServer deployed as a WAR due to limitations in the JEE specification; use mockserver-netty to enable these features";
        if (action instanceof HttpResponse && ((HttpResponse)action).getConnectionOptions() != null) {
            valid = false;
            responseWriter.writeResponse(request, HttpResponse.response("ConnectionOptions" + NOT_SUPPORTED_MESSAGE), true);
        } else if (action instanceof HttpObjectCallback) {
            valid = false;
            responseWriter.writeResponse(request, HttpResponse.response("HttpObjectCallback" + NOT_SUPPORTED_MESSAGE), true);
        } else if (action instanceof HttpError) {
            valid = false;
            responseWriter.writeResponse(request, HttpResponse.response("HttpError" + NOT_SUPPORTED_MESSAGE), true);
        }
        return valid;
    }

    public WebSocketClientRegistry getWebSocketClientRegistry() {
        return this.webSocketClientRegistry;
    }

    public RequestMatchers getRequestMatchers() {
        return this.requestMatchers;
    }

    public MockServerEventLog getMockServerLog() {
        return this.mockServerLog;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public String getUniqueLoopPreventionHeaderName() {
        return "x-forwarded-by";
    }

    public String getUniqueLoopPreventionHeaderValue() {
        return this.uniqueLoopPreventionHeaderValue;
    }

    public void stop() {
        if (this.expectationFileSystemPersistence != null) {
            this.expectationFileSystemPersistence.stop();
        }
        if (this.expectationFileWatcher != null) {
            this.expectationFileWatcher.stop();
        }
        this.getMockServerLog().stop();
    }

    private RequestDefinitionSerializer getRequestDefinitionSerializer() {
        if (this.requestDefinitionSerializer == null) {
            this.requestDefinitionSerializer = new RequestDefinitionSerializer(this.mockServerLogger);
        }
        return this.requestDefinitionSerializer;
    }

    private LogEventRequestAndResponseSerializer getHttpRequestResponseSerializer() {
        if (this.httpRequestResponseSerializer == null) {
            this.httpRequestResponseSerializer = new LogEventRequestAndResponseSerializer(this.mockServerLogger);
        }
        return this.httpRequestResponseSerializer;
    }

    private ExpectationSerializer getExpectationSerializer() {
        if (this.expectationSerializer == null) {
            this.expectationSerializer = new ExpectationSerializer(this.mockServerLogger);
        }
        return this.expectationSerializer;
    }

    private OpenAPIExpectationSerializer getOpenAPIExpectationSerializer() {
        if (this.openAPIExpectationSerializer == null) {
            this.openAPIExpectationSerializer = new OpenAPIExpectationSerializer(this.mockServerLogger);
        }
        return this.openAPIExpectationSerializer;
    }

    private ExpectationToJavaSerializer getExpectationToJavaSerializer() {
        if (this.expectationToJavaSerializer == null) {
            this.expectationToJavaSerializer = new ExpectationToJavaSerializer();
        }
        return this.expectationToJavaSerializer;
    }

    private VerificationSerializer getVerificationSerializer() {
        if (this.verificationSerializer == null) {
            this.verificationSerializer = new VerificationSerializer(this.mockServerLogger);
        }
        return this.verificationSerializer;
    }

    private VerificationSequenceSerializer getVerificationSequenceSerializer() {
        if (this.verificationSequenceSerializer == null) {
            this.verificationSequenceSerializer = new VerificationSequenceSerializer(this.mockServerLogger);
        }
        return this.verificationSequenceSerializer;
    }

    private LogEntrySerializer getLogEntrySerializer() {
        if (this.logEntrySerializer == null) {
            this.logEntrySerializer = new LogEntrySerializer(this.mockServerLogger);
        }
        return this.logEntrySerializer;
    }

    private OpenAPIConverter getOpenAPIConverter() {
        if (this.openAPIConverter == null) {
            this.openAPIConverter = new OpenAPIConverter(this.mockServerLogger);
        }
        return this.openAPIConverter;
    }
}

