/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.main.JsonValidator;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.parser.util.SchemaTypeUtil;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.NottableString;
import org.mockserver.serialization.ObjectMapperFactory;
import org.slf4j.event.Level;

public class NottableSchemaString
extends NottableString {
    private static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger(NottableSchemaString.class);
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.createObjectMapper();
    private static final JsonValidator VALIDATOR = JsonSchemaFactory.byDefault().getValidator();
    private static final DateTimeFormatter RFC3339 = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").appendLiteral('T').appendPattern("HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).parseDefaulting(ChronoField.NANO_OF_SECOND, 0L).optionalEnd().appendOffset("+HH:mm", "Z").toFormatter();
    private static final String TRUE = "true";
    private final ObjectNode schemaJsonNode;
    private final String type;
    private final String format;
    private final String json;

    private static JsonNode convertToJsonNode(@Nonnull String value, String type, String format) throws IOException {
        if ("null".equalsIgnoreCase(value)) {
            return OBJECT_MAPPER.readTree("null");
        }
        if ("date-time".equalsIgnoreCase(format)) {
            String result;
            try {
                result = LocalDateTime.parse(value, RFC3339).format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
            catch (DateTimeParseException e) {
                result = value;
            }
            return new TextNode(result);
        }
        if ("string".equalsIgnoreCase(type)) {
            return new TextNode(value);
        }
        if ("number".equalsIgnoreCase(type) || "integer".equalsIgnoreCase(type)) {
            try {
                Double.parseDouble(value);
                return OBJECT_MAPPER.readTree(value);
            }
            catch (NumberFormatException nfe) {
                return new TextNode(value);
            }
        }
        return OBJECT_MAPPER.readTree(value);
    }

    private ObjectNode getSchemaJsonNode(String schema) {
        try {
            ObjectNode jsonNodes = (ObjectNode)OBJECT_MAPPER.readTree(schema);
            jsonNodes.remove("not");
            return jsonNodes;
        }
        catch (Throwable throwable) {
            MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception loading JSON Schema " + throwable.getMessage()).setThrowable(throwable));
            return null;
        }
    }

    public static NottableSchemaString schemaString(String value, Boolean not) {
        return new NottableSchemaString(value, not);
    }

    public static NottableSchemaString schemaString(String value) {
        return new NottableSchemaString(value);
    }

    public static NottableSchemaString notSchema(String value) {
        return new NottableSchemaString(value, Boolean.TRUE);
    }

    private NottableSchemaString(String schema, Boolean not) {
        super(schema, not);
        if (StringUtils.isNotBlank(schema)) {
            this.schemaJsonNode = this.getSchemaJsonNode(this.getValue());
            Schema schemaByType = SchemaTypeUtil.createSchemaByType(this.schemaJsonNode);
            this.type = schemaByType.getType();
            this.format = schemaByType.getFormat();
        } else {
            this.schemaJsonNode = null;
            this.type = null;
            this.format = null;
        }
        this.json = (Boolean.TRUE.equals(this.isNot()) ? Character.valueOf('!') : "") + schema;
    }

    private NottableSchemaString(String schema) {
        super(schema);
        if (StringUtils.isNotBlank(schema)) {
            this.schemaJsonNode = this.getSchemaJsonNode(this.getValue());
            Schema schemaByType = SchemaTypeUtil.createSchemaByType(this.schemaJsonNode);
            this.type = schemaByType.getType();
            this.format = schemaByType.getFormat();
        } else {
            this.schemaJsonNode = null;
            this.type = null;
            this.format = null;
        }
        this.json = (Boolean.TRUE.equals(this.isNot()) ? Character.valueOf('!') : "") + schema;
    }

    @Override
    public boolean matches(String json) {
        if (this.schemaJsonNode != null) {
            try {
                return this.isNot() != this.validate(json);
            }
            catch (Throwable throwable) {
                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception validating JSON").setThrowable(throwable));
                return this.isNot();
            }
        }
        return !this.isNot();
    }

    private boolean validate(String json) throws ProcessingException, IOException {
        if (this.schemaJsonNode.get("nullable") != null && TRUE.equals(this.schemaJsonNode.get("nullable").asText()) && StringUtils.isBlank(json)) {
            return true;
        }
        return VALIDATOR.validate(this.schemaJsonNode, NottableSchemaString.convertToJsonNode(json, this.type, this.format), false).isSuccess();
    }

    @Override
    public boolean matchesIgnoreCase(String json) {
        return this.matches(json);
    }

    @Override
    public String toString() {
        return this.json;
    }
}

