/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty.proxy.connect;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import org.mockserver.codec.MockServerHttpServerCodec;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.netty.proxy.relay.RelayConnectHandler;

@ChannelHandler.Sharable
public final class HttpConnectHandler
extends RelayConnectHandler<HttpRequest> {
    public HttpConnectHandler(LifeCycle server, MockServerLogger mockServerLogger, String host, int port) {
        super(server, mockServerLogger, host, port);
    }

    @Override
    protected void removeCodecSupport(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.pipeline();
        this.removeHandler(pipeline, HttpServerCodec.class);
        this.removeHandler(pipeline, HttpContentDecompressor.class);
        this.removeHandler(pipeline, HttpObjectAggregator.class);
        this.removeHandler(pipeline, MockServerHttpServerCodec.class);
        if (pipeline.get(this.getClass()) != null) {
            pipeline.remove(this);
        }
    }

    @Override
    protected Object successResponse(Object request) {
        return HttpResponse.response();
    }

    @Override
    protected Object failureResponse(Object request) {
        return HttpResponse.response().withStatusCode(HttpResponseStatus.BAD_GATEWAY.code());
    }
}

