/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty.proxy.relay;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.exception.ExceptionHandling;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.http.HttpActionHandler;
import org.mockserver.netty.proxy.relay.DownstreamProxyRelayHandler;
import org.mockserver.netty.proxy.relay.UpstreamProxyRelayHandler;
import org.mockserver.netty.unification.PortUnificationHandler;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public abstract class RelayConnectHandler<T>
extends SimpleChannelInboundHandler<T> {
    public static final String PROXIED = "PROXIED_";
    public static final String PROXIED_SECURE = "PROXIED_SECURE_";
    public static final String PROXIED_RESPONSE = "PROXIED_RESPONSE_";
    private final LifeCycle server;
    private final MockServerLogger mockServerLogger;
    protected final String host;
    protected final int port;

    public RelayConnectHandler(LifeCycle server, MockServerLogger mockServerLogger, String host, int port) {
        this.server = server;
        this.mockServerLogger = mockServerLogger;
        this.host = host;
        this.port = port;
    }

    @Override
    public void channelRead0(final ChannelHandlerContext proxyClientCtx, final T request) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(proxyClientCtx.channel().eventLoop())).channel(NioSocketChannel.class)).handler(new ChannelInboundHandlerAdapter(){

            @Override
            public void channelActive(ChannelHandlerContext mockServerCtx) {
                if (PortUnificationHandler.isSslEnabledUpstream(proxyClientCtx.channel())) {
                    mockServerCtx.writeAndFlush(Unpooled.copiedBuffer((RelayConnectHandler.PROXIED_SECURE + RelayConnectHandler.this.host + ":" + RelayConnectHandler.this.port).getBytes(StandardCharsets.UTF_8))).awaitUninterruptibly();
                } else {
                    mockServerCtx.writeAndFlush(Unpooled.copiedBuffer((RelayConnectHandler.PROXIED + RelayConnectHandler.this.host + ":" + RelayConnectHandler.this.port).getBytes(StandardCharsets.UTF_8))).awaitUninterruptibly();
                }
            }

            @Override
            public void channelRead(ChannelHandlerContext mockServerCtx, Object msg) {
                if (msg instanceof ByteBuf) {
                    byte[] bytes = ByteBufUtil.getBytes((ByteBuf)msg);
                    if (new String(bytes, StandardCharsets.UTF_8).startsWith(RelayConnectHandler.PROXIED_RESPONSE)) {
                        proxyClientCtx.writeAndFlush(RelayConnectHandler.this.successResponse(request)).addListener(channelFuture -> {
                            RelayConnectHandler.this.removeCodecSupport(proxyClientCtx);
                            ChannelPipeline pipelineToMockServer = mockServerCtx.channel().pipeline();
                            if (PortUnificationHandler.isSslEnabledDownstream(proxyClientCtx.channel())) {
                                pipelineToMockServer.addLast(PortUnificationHandler.nettySslContextFactory(proxyClientCtx.channel()).createClientSslContext(true).newHandler(mockServerCtx.alloc(), RelayConnectHandler.this.host, RelayConnectHandler.this.port));
                            }
                            if (MockServerLogger.isEnabled(Level.TRACE)) {
                                pipelineToMockServer.addLast(new LoggingHandler("downstream                -->"));
                            }
                            pipelineToMockServer.addLast(new HttpClientCodec(ConfigurationProperties.maxInitialLineLength(), ConfigurationProperties.maxHeaderSize(), ConfigurationProperties.maxChunkSize()));
                            pipelineToMockServer.addLast(new HttpContentDecompressor());
                            pipelineToMockServer.addLast(new HttpObjectAggregator(Integer.MAX_VALUE));
                            pipelineToMockServer.addLast(new DownstreamProxyRelayHandler(RelayConnectHandler.this.mockServerLogger, proxyClientCtx.channel()));
                            ChannelPipeline pipelineToProxyClient = proxyClientCtx.channel().pipeline();
                            if (PortUnificationHandler.isSslEnabledUpstream(proxyClientCtx.channel()) && pipelineToProxyClient.get(SslHandler.class) == null) {
                                pipelineToProxyClient.addLast(PortUnificationHandler.nettySslContextFactory(proxyClientCtx.channel()).createServerSslContext().newHandler(proxyClientCtx.alloc()));
                            }
                            if (MockServerLogger.isEnabled(Level.TRACE)) {
                                pipelineToProxyClient.addLast(new LoggingHandler("upstream <-- "));
                            }
                            pipelineToProxyClient.addLast(new HttpServerCodec(ConfigurationProperties.maxInitialLineLength(), ConfigurationProperties.maxHeaderSize(), ConfigurationProperties.maxChunkSize()));
                            pipelineToProxyClient.addLast(new HttpContentDecompressor());
                            pipelineToProxyClient.addLast(new HttpObjectAggregator(Integer.MAX_VALUE));
                            pipelineToProxyClient.addLast(new UpstreamProxyRelayHandler(RelayConnectHandler.this.mockServerLogger, proxyClientCtx.channel(), mockServerCtx.channel()));
                        });
                    } else {
                        mockServerCtx.fireChannelRead(Unpooled.copiedBuffer(bytes));
                    }
                }
            }
        });
        InetSocketAddress remoteSocket = this.getDownstreamSocket(proxyClientCtx);
        bootstrap.connect(remoteSocket).addListener(future -> {
            if (future.isSuccess()) {
                if (MockServerLogger.isEnabled(Level.DEBUG)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("connected to{}").setArguments(remoteSocket));
                }
            } else {
                this.failure("Connection failed to " + remoteSocket, future.cause(), proxyClientCtx, this.failureResponse(request));
            }
        });
    }

    private InetSocketAddress getDownstreamSocket(ChannelHandlerContext ctx) {
        InetSocketAddress remoteAddress = HttpActionHandler.getRemoteAddress(ctx);
        if (remoteAddress != null) {
            return remoteAddress;
        }
        return new InetSocketAddress(this.server.getLocalPort());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.failure("Exception caught by CONNECT proxy handler -> closing pipeline ", cause, ctx, this.failureResponse(null));
    }

    private void failure(String message, Throwable cause, ChannelHandlerContext ctx, Object response) {
        if (ExceptionHandling.connectionClosedException(cause)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat(message).setThrowable(cause));
        }
        Channel channel = ctx.channel();
        channel.writeAndFlush(response);
        if (channel.isActive()) {
            channel.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
    }

    protected abstract void removeCodecSupport(ChannelHandlerContext var1);

    protected abstract Object successResponse(Object var1);

    protected abstract Object failureResponse(Object var1);

    protected void removeHandler(ChannelPipeline pipeline, Class<? extends ChannelHandler> handlerType) {
        if (pipeline.get(handlerType) != null) {
            pipeline.remove(handlerType);
        }
    }

    protected void removeHandler(ChannelPipeline pipeline, ChannelHandler channelHandler) {
        if (pipeline.toMap().containsValue(channelHandler)) {
            pipeline.remove(channelHandler);
        }
    }
}

