/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.serializers.collections;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Collection;
import org.mockserver.model.KeyMatchStyle;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.KeysToMultiValues;
import org.mockserver.model.NottableString;

public abstract class KeysToMultiValuesSerializer<T extends KeysToMultiValues<? extends KeyToMultiValue, T>>
extends StdSerializer<T> {
    KeysToMultiValuesSerializer(Class<T> valueClass) {
        super(valueClass);
    }

    @Override
    public void serialize(T collection, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (((KeysToMultiValues)collection).getKeyMatchStyle() != null && ((KeysToMultiValues)collection).getKeyMatchStyle() != KeyMatchStyle.SUB_SET) {
            jgen.writeObjectField("keyMatchStyle", (Object)((KeysToMultiValues)collection).getKeyMatchStyle());
        }
        for (NottableString key : ((KeysToMultiValues)collection).keySet()) {
            jgen.writeFieldName(NottableString.serialiseNottableString(key));
            if (key.getParameterStyle() != null) {
                jgen.writeStartObject();
                jgen.writeObjectField("parameterStyle", (Object)key.getParameterStyle());
                jgen.writeFieldName("values");
                this.writeValuesArray(collection, jgen, key);
                jgen.writeEndObject();
                continue;
            }
            this.writeValuesArray(collection, jgen, key);
        }
        jgen.writeEndObject();
    }

    private void writeValuesArray(T collection, JsonGenerator jgen, NottableString key) throws IOException {
        Collection<NottableString> values = ((KeysToMultiValues)collection).getValues(key);
        jgen.writeStartArray(values.size());
        for (NottableString nottableString : values) {
            jgen.writeObject(nottableString);
        }
        jgen.writeEndArray();
    }
}

