/*
 * Copyright (c) 2016 Mockito contributors
 * This program is made available under the terms of the MIT License.
 */
package org.mockito.verification;

import java.time.Duration;

import org.mockito.internal.verification.VerificationOverTimeImpl;
import org.mockito.internal.verification.VerificationWrapper;

/**
 * See the javadoc for {@link VerificationAfterDelay}
 * <p>
 * Typically, you won't use this class explicitly. Instead use timeout() method on Mockito class.
 * See javadoc for {@link VerificationWithTimeout}
 */
public class After extends VerificationWrapper<VerificationOverTimeImpl> implements VerificationAfterDelay {

    /**
     * See the javadoc for {@link VerificationAfterDelay}
     * <p>
     * Typically, you won't use this class explicitly. Instead use timeout() method on Mockito class.
     * See javadoc for {@link VerificationWithTimeout}
     * @deprecated Use {@link After#After(Duration, VerificationMode)} instead.
     */
    @Deprecated
    public After(long delayMillis, VerificationMode verificationMode) {
        this(Duration.ofMillis(delayMillis), verificationMode);
    }

    /**
     * See the javadoc for {@link VerificationAfterDelay}
     * <p>
     * Typically, you won't use this class explicitly. Instead use timeout() method on Mockito class.
     * See javadoc for {@link VerificationWithTimeout}
     */
    public After(Duration delay, VerificationMode verificationMode) {
        this(Duration.ofMillis(10), delay, verificationMode);
    }

    After(Duration pollingPeriod, Duration delay, VerificationMode verificationMode) {
        this(new VerificationOverTimeImpl(pollingPeriod, delay, verificationMode, false));
    }

    After(VerificationOverTimeImpl verificationOverTime) {
        super(verificationOverTime);
    }

    @Override
    protected VerificationMode copySelfWithNewVerificationMode(VerificationMode verificationMode) {
        return new After(wrappedVerification.copyWithVerificationMode(verificationMode));
    }
}
