/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util;

import java.time.Duration;
import java.time.Instant;
import org.mockito.internal.exceptions.Reporter;

public class Timer {
    private final Duration duration;
    private Instant startTime = null;

    public Timer(Duration duration) {
        this.validateInput(duration);
        this.duration = duration;
    }

    public boolean isCounting() {
        assert (this.startTime != null);
        Duration elapsed = Duration.between(this.startTime, Instant.now());
        return elapsed.compareTo(this.duration) <= 0;
    }

    public void start() {
        this.startTime = Instant.now();
    }

    private void validateInput(Duration duration) {
        if (duration.isNegative()) {
            throw Reporter.cannotCreateTimerWithNegativeDurationTime(duration);
        }
    }

    public Duration duration() {
        return this.duration;
    }
}

