/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.plugins;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.mockito.internal.configuration.plugins.DefaultMockitoPlugins;
import org.mockito.internal.configuration.plugins.PluginInitializer;
import org.mockito.plugins.PluginSwitch;

class PluginLoader {
    private final DefaultMockitoPlugins plugins;
    private final PluginInitializer initializer;

    PluginLoader(DefaultMockitoPlugins plugins, PluginInitializer initializer) {
        this.plugins = plugins;
        this.initializer = initializer;
    }

    PluginLoader(PluginSwitch pluginSwitch) {
        this(new DefaultMockitoPlugins(), new PluginInitializer(pluginSwitch, Collections.emptySet()));
    }

    PluginLoader(PluginSwitch pluginSwitch, String ... alias) {
        this(new DefaultMockitoPlugins(), new PluginInitializer(pluginSwitch, new HashSet<String>(Arrays.asList(alias))));
    }

    <T> T loadPlugin(Class<T> pluginType) {
        return (T)this.loadPlugin(pluginType, null);
    }

    <PreferredT, AlternateType> Object loadPlugin(final Class<PreferredT> preferredPluginType, final Class<AlternateType> alternatePluginType) {
        try {
            AlternateType alternatePlugin;
            PreferredT preferredPlugin = this.initializer.loadImpl(preferredPluginType);
            if (preferredPlugin != null) {
                return preferredPlugin;
            }
            if (alternatePluginType != null && (alternatePlugin = this.initializer.loadImpl(alternatePluginType)) != null) {
                return alternatePlugin;
            }
            return this.plugins.getDefaultPlugin(preferredPluginType);
        }
        catch (Throwable t) {
            return Proxy.newProxyInstance(preferredPluginType.getClassLoader(), new Class[]{preferredPluginType}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    throw new IllegalStateException("Could not initialize plugin: " + String.valueOf(preferredPluginType) + " (alternate: " + String.valueOf(alternatePluginType) + ")", t);
                }
            });
        }
    }

    <T> List<T> loadPlugins(final Class<T> pluginType) {
        try {
            return this.initializer.loadImpls(pluginType);
        }
        catch (Throwable t) {
            return Collections.singletonList(Proxy.newProxyInstance(pluginType.getClassLoader(), new Class[]{pluginType}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    throw new IllegalStateException("Could not initialize plugin: " + String.valueOf(pluginType), t);
                }
            }));
        }
    }
}

