/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.ChangeStreamPreAndPostImagesOptions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.TimeSeriesGranularity;
import com.mongodb.client.model.TimeSeriesOptions;
import com.mongodb.client.model.ValidationAction;
import com.mongodb.client.model.ValidationLevel;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.Supplier;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

public class CreateCollectionOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private static final String ENCRYPT_PREFIX = "enxcol_.";
    private static final BsonDocument ENCRYPT_CLUSTERED_INDEX = BsonDocument.parse((String)"{key: {_id: 1}, unique: true}");
    private static final BsonArray SAFE_CONTENT_ARRAY = new BsonArray(Collections.singletonList(BsonDocument.parse((String)"{key: {__safeContent__: 1}, name: '__safeContent___1'}")));
    private final String databaseName;
    private final String collectionName;
    private final WriteConcern writeConcern;
    private boolean capped = false;
    private long sizeInBytes = 0L;
    private boolean autoIndex = true;
    private long maxDocuments = 0L;
    private BsonDocument storageEngineOptions;
    private BsonDocument indexOptionDefaults;
    private BsonDocument validator;
    private ValidationLevel validationLevel = null;
    private ValidationAction validationAction = null;
    private Collation collation = null;
    private long expireAfterSeconds;
    private TimeSeriesOptions timeSeriesOptions;
    private ChangeStreamPreAndPostImagesOptions changeStreamPreAndPostImagesOptions;
    private BsonDocument clusteredIndexKey;
    private boolean clusteredIndexUnique;
    private String clusteredIndexName;
    private BsonDocument encryptedFields;

    public CreateCollectionOperation(String databaseName, String collectionName) {
        this(databaseName, collectionName, null);
    }

    public CreateCollectionOperation(String databaseName, String collectionName, @Nullable WriteConcern writeConcern) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.collectionName = Assertions.notNull("collectionName", collectionName);
        this.writeConcern = writeConcern;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean isAutoIndex() {
        return this.autoIndex;
    }

    public CreateCollectionOperation autoIndex(boolean autoIndex) {
        this.autoIndex = autoIndex;
        return this;
    }

    public long getMaxDocuments() {
        return this.maxDocuments;
    }

    public CreateCollectionOperation maxDocuments(long maxDocuments) {
        this.maxDocuments = maxDocuments;
        return this;
    }

    public boolean isCapped() {
        return this.capped;
    }

    public CreateCollectionOperation capped(boolean capped) {
        this.capped = capped;
        return this;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public CreateCollectionOperation sizeInBytes(long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
        return this;
    }

    public BsonDocument getStorageEngineOptions() {
        return this.storageEngineOptions;
    }

    public CreateCollectionOperation storageEngineOptions(@Nullable BsonDocument storageEngineOptions) {
        this.storageEngineOptions = storageEngineOptions;
        return this;
    }

    public BsonDocument getIndexOptionDefaults() {
        return this.indexOptionDefaults;
    }

    public CreateCollectionOperation indexOptionDefaults(@Nullable BsonDocument indexOptionDefaults) {
        this.indexOptionDefaults = indexOptionDefaults;
        return this;
    }

    public BsonDocument getValidator() {
        return this.validator;
    }

    public CreateCollectionOperation validator(@Nullable BsonDocument validator) {
        this.validator = validator;
        return this;
    }

    public ValidationLevel getValidationLevel() {
        return this.validationLevel;
    }

    public CreateCollectionOperation validationLevel(@Nullable ValidationLevel validationLevel) {
        this.validationLevel = validationLevel;
        return this;
    }

    public ValidationAction getValidationAction() {
        return this.validationAction;
    }

    public CreateCollectionOperation validationAction(@Nullable ValidationAction validationAction) {
        this.validationAction = validationAction;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public CreateCollectionOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public CreateCollectionOperation expireAfter(long expireAfterSeconds) {
        this.expireAfterSeconds = expireAfterSeconds;
        return this;
    }

    public CreateCollectionOperation timeSeriesOptions(@Nullable TimeSeriesOptions timeSeriesOptions) {
        this.timeSeriesOptions = timeSeriesOptions;
        return this;
    }

    public CreateCollectionOperation changeStreamPreAndPostImagesOptions(@Nullable ChangeStreamPreAndPostImagesOptions changeStreamPreAndPostImagesOptions) {
        this.changeStreamPreAndPostImagesOptions = changeStreamPreAndPostImagesOptions;
        return this;
    }

    public CreateCollectionOperation clusteredIndexKey(@Nullable BsonDocument clusteredIndexKey) {
        this.clusteredIndexKey = clusteredIndexKey;
        return this;
    }

    public CreateCollectionOperation clusteredIndexUnique(boolean clusteredIndexUnique) {
        this.clusteredIndexUnique = clusteredIndexUnique;
        return this;
    }

    public CreateCollectionOperation clusteredIndexName(@Nullable String clusteredIndexName) {
        this.clusteredIndexName = clusteredIndexName;
        return this;
    }

    public CreateCollectionOperation encryptedFields(@Nullable BsonDocument encryptedFields) {
        this.encryptedFields = encryptedFields;
        return this;
    }

    @Override
    public Void execute(WriteBinding binding) {
        return OperationHelper.withConnection(binding, connection -> {
            this.getCommandFunctions().forEach(commandCreator -> CommandOperationHelper.executeCommand(binding, this.databaseName, (BsonDocument)commandCreator.get(), connection, CommandOperationHelper.writeConcernErrorTransformer()));
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        OperationHelper.withAsyncConnection(binding, (connection, t) -> {
            SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
            if (t != null) {
                errHandlingCallback.onResult(null, t);
            } else {
                new ProcessCommandsCallback(binding, connection, OperationHelper.releasingCallback(errHandlingCallback, connection)).onResult(null, null);
            }
        });
    }

    private String getGranularityAsString(TimeSeriesGranularity granularity) {
        switch (granularity) {
            case SECONDS: {
                return "seconds";
            }
            case MINUTES: {
                return "minutes";
            }
            case HOURS: {
                return "hours";
            }
        }
        throw new AssertionError((Object)("Unexpected granularity " + (Object)((Object)granularity)));
    }

    private List<Supplier<BsonDocument>> getCommandFunctions() {
        if (this.encryptedFields == null) {
            return Collections.singletonList(this::getCreateCollectionCommand);
        }
        return Arrays.asList(() -> this.getCreateEncryptedFieldsCollectionCommand("esc"), () -> this.getCreateEncryptedFieldsCollectionCommand("ecc"), () -> this.getCreateEncryptedFieldsCollectionCommand("ecoc"), this::getCreateCollectionCommand, () -> new BsonDocument("createIndexes", (BsonValue)new BsonString(this.collectionName)).append("indexes", (BsonValue)SAFE_CONTENT_ARRAY));
    }

    private BsonDocument getCreateEncryptedFieldsCollectionCommand(String collectionSuffix) {
        return new BsonDocument().append("create", (BsonValue)this.encryptedFields.getOrDefault((Object)(collectionSuffix + "Collection"), (Object)new BsonString(ENCRYPT_PREFIX + this.collectionName + "." + collectionSuffix))).append("clusteredIndex", (BsonValue)ENCRYPT_CLUSTERED_INDEX);
    }

    private BsonDocument getCreateCollectionCommand() {
        BsonDocument document = new BsonDocument("create", (BsonValue)new BsonString(this.collectionName));
        DocumentHelper.putIfFalse(document, "autoIndexId", this.autoIndex);
        document.put("capped", (BsonValue)BsonBoolean.valueOf((boolean)this.capped));
        if (this.capped) {
            DocumentHelper.putIfNotZero(document, "size", this.sizeInBytes);
            DocumentHelper.putIfNotZero(document, "max", this.maxDocuments);
        }
        DocumentHelper.putIfNotNull(document, "storageEngine", (BsonValue)this.storageEngineOptions);
        DocumentHelper.putIfNotNull(document, "indexOptionDefaults", (BsonValue)this.indexOptionDefaults);
        DocumentHelper.putIfNotNull(document, "validator", (BsonValue)this.validator);
        if (this.validationLevel != null) {
            document.put("validationLevel", (BsonValue)new BsonString(this.validationLevel.getValue()));
        }
        if (this.validationAction != null) {
            document.put("validationAction", (BsonValue)new BsonString(this.validationAction.getValue()));
        }
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, document);
        if (this.collation != null) {
            document.put("collation", (BsonValue)this.collation.asDocument());
        }
        DocumentHelper.putIfNotZero(document, "expireAfterSeconds", this.expireAfterSeconds);
        if (this.timeSeriesOptions != null) {
            TimeSeriesGranularity granularity;
            BsonDocument timeSeriesDocument = new BsonDocument("timeField", (BsonValue)new BsonString(this.timeSeriesOptions.getTimeField()));
            String metaField = this.timeSeriesOptions.getMetaField();
            if (metaField != null) {
                timeSeriesDocument.put("metaField", (BsonValue)new BsonString(metaField));
            }
            if ((granularity = this.timeSeriesOptions.getGranularity()) != null) {
                timeSeriesDocument.put("granularity", (BsonValue)new BsonString(this.getGranularityAsString(granularity)));
            }
            document.put("timeseries", (BsonValue)timeSeriesDocument);
        }
        if (this.changeStreamPreAndPostImagesOptions != null) {
            document.put("changeStreamPreAndPostImages", (BsonValue)new BsonDocument("enabled", (BsonValue)BsonBoolean.valueOf((boolean)this.changeStreamPreAndPostImagesOptions.isEnabled())));
        }
        if (this.clusteredIndexKey != null) {
            BsonDocument clusteredIndexDocument = new BsonDocument().append("key", (BsonValue)this.clusteredIndexKey).append("unique", (BsonValue)BsonBoolean.valueOf((boolean)this.clusteredIndexUnique));
            if (this.clusteredIndexName != null) {
                clusteredIndexDocument.put("name", (BsonValue)new BsonString(this.clusteredIndexName));
            }
            document.put("clusteredIndex", (BsonValue)clusteredIndexDocument);
        }
        DocumentHelper.putIfNotNull(document, "encryptedFields", (BsonValue)this.encryptedFields);
        return document;
    }

    class ProcessCommandsCallback
    implements SingleResultCallback<Void> {
        private final AsyncWriteBinding binding;
        private final AsyncConnection connection;
        private final SingleResultCallback<Void> finalCallback;
        private final Deque<Supplier<BsonDocument>> commands;

        ProcessCommandsCallback(AsyncWriteBinding binding, AsyncConnection connection, SingleResultCallback<Void> finalCallback) {
            this.binding = binding;
            this.connection = connection;
            this.finalCallback = finalCallback;
            this.commands = new ArrayDeque<Supplier<BsonDocument>>(CreateCollectionOperation.this.getCommandFunctions());
        }

        @Override
        public void onResult(@Nullable Void result, @Nullable Throwable t) {
            if (t != null) {
                this.finalCallback.onResult(null, t);
                return;
            }
            Supplier<BsonDocument> nextCommandFunction = this.commands.poll();
            if (nextCommandFunction == null) {
                this.finalCallback.onResult(null, null);
            } else {
                CommandOperationHelper.executeCommandAsync(this.binding, CreateCollectionOperation.this.databaseName, nextCommandFunction.get(), this.connection, CommandOperationHelper.writeConcernErrorWriteTransformer(), this);
            }
        }
    }
}

