/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBEncoderFactory;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.DefaultDBEncoder;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.event.ClusterListener;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import com.mongodb.event.ServerListener;
import com.mongodb.event.ServerMonitorListener;
import com.mongodb.lang.Nullable;
import com.mongodb.selector.ServerSelector;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecRegistry;

@Immutable
public class MongoClientOptions {
    private final MongoClientSettings wrapped;
    private final DBDecoderFactory dbDecoderFactory;
    private final DBEncoderFactory dbEncoderFactory;
    private final boolean cursorFinalizerEnabled;

    private MongoClientOptions(Builder builder) {
        this.wrapped = builder.wrapped.build();
        this.dbDecoderFactory = builder.dbDecoderFactory;
        this.dbEncoderFactory = builder.dbEncoderFactory;
        this.cursorFinalizerEnabled = builder.cursorFinalizerEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MongoClientOptions options) {
        return new Builder(options);
    }

    public static Builder builder(MongoClientSettings settings) {
        return new Builder(settings);
    }

    public MongoClientSettings asMongoClientSettings(@Nullable List<ServerAddress> hosts, @Nullable String srvHost, ClusterConnectionMode clusterConnectionMode, @Nullable MongoCredential credential) {
        MongoClientSettings.Builder mongoClientSettingsBuilder = MongoClientSettings.builder((MongoClientSettings)this.wrapped);
        Optional.ofNullable(credential).ifPresent(arg_0 -> ((MongoClientSettings.Builder)mongoClientSettingsBuilder).credential(arg_0));
        mongoClientSettingsBuilder.applyToClusterSettings(builder -> {
            builder.mode(clusterConnectionMode);
            if (srvHost != null) {
                builder.srvHost(srvHost);
            }
            if (hosts != null) {
                builder.hosts(hosts);
            }
        });
        return mongoClientSettingsBuilder.build();
    }

    @Nullable
    public String getApplicationName() {
        return this.wrapped.getApplicationName();
    }

    public List<MongoCompressor> getCompressorList() {
        return this.wrapped.getCompressorList();
    }

    public int getConnectionsPerHost() {
        return this.wrapped.getConnectionPoolSettings().getMaxSize();
    }

    public int getMinConnectionsPerHost() {
        return this.wrapped.getConnectionPoolSettings().getMinSize();
    }

    public int getServerSelectionTimeout() {
        return Math.toIntExact(this.wrapped.getClusterSettings().getServerSelectionTimeout(TimeUnit.MILLISECONDS));
    }

    public int getMaxWaitTime() {
        return Math.toIntExact(this.wrapped.getConnectionPoolSettings().getMaxWaitTime(TimeUnit.MILLISECONDS));
    }

    public int getMaxConnectionIdleTime() {
        return Math.toIntExact(this.wrapped.getConnectionPoolSettings().getMaxConnectionIdleTime(TimeUnit.MILLISECONDS));
    }

    public int getMaxConnectionLifeTime() {
        return Math.toIntExact(this.wrapped.getConnectionPoolSettings().getMaxConnectionLifeTime(TimeUnit.MILLISECONDS));
    }

    public int getMaxConnecting() {
        return this.wrapped.getConnectionPoolSettings().getMaxConnecting();
    }

    public long getMaintenanceInitialDelay() {
        return this.wrapped.getConnectionPoolSettings().getMaintenanceInitialDelay(TimeUnit.MILLISECONDS);
    }

    public long getMaintenanceFrequency() {
        return this.wrapped.getConnectionPoolSettings().getMaintenanceFrequency(TimeUnit.MILLISECONDS);
    }

    public int getConnectTimeout() {
        return this.wrapped.getSocketSettings().getConnectTimeout(TimeUnit.MILLISECONDS);
    }

    public int getSocketTimeout() {
        return this.wrapped.getSocketSettings().getReadTimeout(TimeUnit.MILLISECONDS);
    }

    public int getHeartbeatFrequency() {
        return Math.toIntExact(this.wrapped.getServerSettings().getHeartbeatFrequency(TimeUnit.MILLISECONDS));
    }

    public int getMinHeartbeatFrequency() {
        return Math.toIntExact(this.wrapped.getServerSettings().getMinHeartbeatFrequency(TimeUnit.MILLISECONDS));
    }

    public int getHeartbeatConnectTimeout() {
        return this.wrapped.getHeartbeatSocketSettings().getConnectTimeout(TimeUnit.MILLISECONDS);
    }

    public int getHeartbeatSocketTimeout() {
        return this.wrapped.getHeartbeatSocketSettings().getReadTimeout(TimeUnit.MILLISECONDS);
    }

    public int getLocalThreshold() {
        return Math.toIntExact(this.wrapped.getClusterSettings().getLocalThreshold(TimeUnit.MILLISECONDS));
    }

    @Nullable
    public String getRequiredReplicaSetName() {
        return this.wrapped.getClusterSettings().getRequiredReplicaSetName();
    }

    public boolean isSslEnabled() {
        return this.wrapped.getSslSettings().isEnabled();
    }

    public boolean isSslInvalidHostNameAllowed() {
        return this.wrapped.getSslSettings().isInvalidHostNameAllowed();
    }

    @Nullable
    public SSLContext getSslContext() {
        return this.wrapped.getSslSettings().getContext();
    }

    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    public WriteConcern getWriteConcern() {
        return this.wrapped.getWriteConcern();
    }

    public boolean getRetryWrites() {
        return this.wrapped.getRetryWrites();
    }

    public boolean getRetryReads() {
        return this.wrapped.getRetryReads();
    }

    public ReadConcern getReadConcern() {
        return this.wrapped.getReadConcern();
    }

    public CodecRegistry getCodecRegistry() {
        return this.wrapped.getCodecRegistry();
    }

    public UuidRepresentation getUuidRepresentation() {
        return this.wrapped.getUuidRepresentation();
    }

    @Nullable
    public Integer getSrvMaxHosts() {
        return this.wrapped.getClusterSettings().getSrvMaxHosts();
    }

    public String getSrvServiceName() {
        return this.wrapped.getClusterSettings().getSrvServiceName();
    }

    @Nullable
    public ServerApi getServerApi() {
        return this.wrapped.getServerApi();
    }

    @Nullable
    public ServerSelector getServerSelector() {
        return this.wrapped.getClusterSettings().getServerSelector();
    }

    public List<ClusterListener> getClusterListeners() {
        return this.wrapped.getClusterSettings().getClusterListeners();
    }

    public List<CommandListener> getCommandListeners() {
        return this.wrapped.getCommandListeners();
    }

    public List<ConnectionPoolListener> getConnectionPoolListeners() {
        return this.wrapped.getConnectionPoolSettings().getConnectionPoolListeners();
    }

    public List<ServerListener> getServerListeners() {
        return this.wrapped.getServerSettings().getServerListeners();
    }

    public List<ServerMonitorListener> getServerMonitorListeners() {
        return this.wrapped.getServerSettings().getServerMonitorListeners();
    }

    public DBDecoderFactory getDbDecoderFactory() {
        return this.dbDecoderFactory;
    }

    public DBEncoderFactory getDbEncoderFactory() {
        return this.dbEncoderFactory;
    }

    public boolean isCursorFinalizerEnabled() {
        return this.cursorFinalizerEnabled;
    }

    @Nullable
    public AutoEncryptionSettings getAutoEncryptionSettings() {
        return this.wrapped.getAutoEncryptionSettings();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoClientOptions that = (MongoClientOptions)o;
        return this.wrapped.equals((Object)that.wrapped) && this.cursorFinalizerEnabled == that.cursorFinalizerEnabled && this.dbDecoderFactory.equals(that.dbDecoderFactory) && this.dbEncoderFactory.equals(that.dbEncoderFactory);
    }

    public int hashCode() {
        return Objects.hash(this.wrapped, this.dbDecoderFactory, this.dbEncoderFactory, this.cursorFinalizerEnabled);
    }

    public String toString() {
        return "MongoClientOptions{wrapped=" + this.wrapped + ", dbDecoderFactory=" + this.dbDecoderFactory + ", dbEncoderFactory=" + this.dbEncoderFactory + ", cursorFinalizerEnabled=" + this.cursorFinalizerEnabled + '}';
    }

    @NotThreadSafe
    public static class Builder {
        private final MongoClientSettings.Builder wrapped;
        private DBDecoderFactory dbDecoderFactory = DefaultDBDecoder.FACTORY;
        private DBEncoderFactory dbEncoderFactory = DefaultDBEncoder.FACTORY;
        private boolean cursorFinalizerEnabled = true;

        public Builder() {
            this.wrapped = MongoClientSettings.builder();
        }

        public Builder(MongoClientOptions options) {
            this.wrapped = MongoClientSettings.builder((MongoClientSettings)options.wrapped);
            this.dbDecoderFactory = options.dbDecoderFactory;
            this.dbEncoderFactory = options.dbEncoderFactory;
            this.cursorFinalizerEnabled = options.cursorFinalizerEnabled;
        }

        Builder(MongoClientSettings settings) {
            this.wrapped = MongoClientSettings.builder((MongoClientSettings)settings);
        }

        public Builder applicationName(@Nullable String applicationName) {
            this.wrapped.applicationName(applicationName);
            return this;
        }

        public Builder compressorList(List<MongoCompressor> compressorList) {
            this.wrapped.compressorList(compressorList);
            return this;
        }

        public Builder minConnectionsPerHost(int minConnectionsPerHost) {
            this.wrapped.applyToConnectionPoolSettings(builder -> builder.minSize(minConnectionsPerHost));
            return this;
        }

        public Builder connectionsPerHost(int connectionsPerHost) {
            this.wrapped.applyToConnectionPoolSettings(builder -> builder.maxSize(connectionsPerHost));
            return this;
        }

        public Builder serverSelectionTimeout(int serverSelectionTimeout) {
            this.wrapped.applyToClusterSettings(builder -> builder.serverSelectionTimeout((long)serverSelectionTimeout, TimeUnit.MILLISECONDS));
            return this;
        }

        public Builder maxWaitTime(int maxWaitTime) {
            this.wrapped.applyToConnectionPoolSettings(builder -> builder.maxWaitTime((long)maxWaitTime, TimeUnit.MILLISECONDS));
            return this;
        }

        public Builder maxConnectionIdleTime(int maxConnectionIdleTime) {
            this.wrapped.applyToConnectionPoolSettings(builder -> builder.maxConnectionIdleTime((long)maxConnectionIdleTime, TimeUnit.MILLISECONDS));
            return this;
        }

        public Builder maxConnectionLifeTime(int maxConnectionLifeTime) {
            this.wrapped.applyToConnectionPoolSettings(builder -> builder.maxConnectionLifeTime((long)maxConnectionLifeTime, TimeUnit.MILLISECONDS));
            return this;
        }

        public Builder maxConnecting(int maxConnecting) {
            this.wrapped.applyToConnectionPoolSettings(builder -> builder.maxConnecting(maxConnecting));
            return this;
        }

        public Builder maintenanceInitialDelay(long maintenanceInitialDelay) {
            this.wrapped.applyToConnectionPoolSettings(builder -> builder.maintenanceInitialDelay(maintenanceInitialDelay, TimeUnit.MILLISECONDS));
            return this;
        }

        public Builder maintenanceFrequency(long maintenanceFrequency) {
            this.wrapped.applyToConnectionPoolSettings(builder -> builder.maintenanceFrequency(maintenanceFrequency, TimeUnit.MILLISECONDS));
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.wrapped.applyToSocketSettings(builder -> builder.connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS));
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.wrapped.applyToSocketSettings(builder -> builder.readTimeout((long)socketTimeout, TimeUnit.MILLISECONDS));
            return this;
        }

        public Builder sslEnabled(boolean sslEnabled) {
            this.wrapped.applyToSslSettings(builder -> builder.enabled(sslEnabled));
            return this;
        }

        public Builder sslInvalidHostNameAllowed(boolean sslInvalidHostNameAllowed) {
            this.wrapped.applyToSslSettings(builder -> builder.invalidHostNameAllowed(sslInvalidHostNameAllowed));
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.wrapped.applyToSslSettings(builder -> builder.context(sslContext));
            return this;
        }

        public Builder readPreference(ReadPreference readPreference) {
            this.wrapped.readPreference(readPreference);
            return this;
        }

        public Builder writeConcern(WriteConcern writeConcern) {
            this.wrapped.writeConcern(writeConcern);
            return this;
        }

        public Builder retryWrites(boolean retryWrites) {
            this.wrapped.retryWrites(retryWrites);
            return this;
        }

        public Builder retryReads(boolean retryReads) {
            this.wrapped.retryReads(retryReads);
            return this;
        }

        public Builder readConcern(ReadConcern readConcern) {
            this.wrapped.readConcern(readConcern);
            return this;
        }

        public Builder codecRegistry(CodecRegistry codecRegistry) {
            this.wrapped.codecRegistry(codecRegistry);
            return this;
        }

        public Builder uuidRepresentation(UuidRepresentation uuidRepresentation) {
            this.wrapped.uuidRepresentation(uuidRepresentation);
            return this;
        }

        public Builder serverApi(ServerApi serverApi) {
            this.wrapped.serverApi(serverApi);
            return this;
        }

        public Builder serverSelector(ServerSelector serverSelector) {
            this.wrapped.applyToClusterSettings(builder -> builder.serverSelector(serverSelector));
            return this;
        }

        public Builder addCommandListener(CommandListener commandListener) {
            this.wrapped.addCommandListener(commandListener);
            return this;
        }

        public Builder addConnectionPoolListener(ConnectionPoolListener connectionPoolListener) {
            this.wrapped.applyToConnectionPoolSettings(builder -> builder.addConnectionPoolListener(connectionPoolListener));
            return this;
        }

        public Builder addClusterListener(ClusterListener clusterListener) {
            this.wrapped.applyToClusterSettings(builder -> builder.addClusterListener(clusterListener));
            return this;
        }

        public Builder addServerListener(ServerListener serverListener) {
            this.wrapped.applyToServerSettings(builder -> builder.addServerListener(serverListener));
            return this;
        }

        public Builder addServerMonitorListener(ServerMonitorListener serverMonitorListener) {
            this.wrapped.applyToServerSettings(builder -> builder.addServerMonitorListener(serverMonitorListener));
            return this;
        }

        public Builder cursorFinalizerEnabled(boolean cursorFinalizerEnabled) {
            this.cursorFinalizerEnabled = cursorFinalizerEnabled;
            return this;
        }

        public Builder dbDecoderFactory(DBDecoderFactory dbDecoderFactory) {
            this.dbDecoderFactory = (DBDecoderFactory)Assertions.notNull((String)"dbDecoderFactory", (Object)dbDecoderFactory);
            return this;
        }

        public Builder dbEncoderFactory(DBEncoderFactory dbEncoderFactory) {
            this.dbEncoderFactory = (DBEncoderFactory)Assertions.notNull((String)"dbEncoderFactory", (Object)dbEncoderFactory);
            return this;
        }

        public Builder heartbeatFrequency(int heartbeatFrequency) {
            this.wrapped.applyToServerSettings(builder -> builder.heartbeatFrequency((long)heartbeatFrequency, TimeUnit.MILLISECONDS));
            return this;
        }

        public Builder minHeartbeatFrequency(int minHeartbeatFrequency) {
            this.wrapped.applyToServerSettings(builder -> builder.minHeartbeatFrequency((long)minHeartbeatFrequency, TimeUnit.MILLISECONDS));
            return this;
        }

        public Builder heartbeatConnectTimeout(int connectTimeout) {
            this.wrapped.heartbeatConnectTimeoutMS(connectTimeout);
            return this;
        }

        public Builder heartbeatSocketTimeout(int socketTimeout) {
            this.wrapped.heartbeatSocketTimeoutMS(socketTimeout);
            return this;
        }

        public Builder localThreshold(int localThreshold) {
            this.wrapped.applyToClusterSettings(builder -> builder.localThreshold((long)localThreshold, TimeUnit.MILLISECONDS));
            return this;
        }

        public Builder requiredReplicaSetName(String requiredReplicaSetName) {
            this.wrapped.applyToClusterSettings(builder -> builder.requiredReplicaSetName(requiredReplicaSetName));
            return this;
        }

        public Builder autoEncryptionSettings(AutoEncryptionSettings autoEncryptionSettings) {
            this.wrapped.autoEncryptionSettings(autoEncryptionSettings);
            return this;
        }

        public Builder srvMaxHosts(Integer srvMaxHosts) {
            this.wrapped.applyToClusterSettings(builder -> builder.srvMaxHosts(srvMaxHosts));
            return this;
        }

        public Builder srvServiceName(String srvServiceName) {
            this.wrapped.applyToClusterSettings(builder -> builder.srvServiceName(srvServiceName));
            return this;
        }

        public MongoClientOptions build() {
            return new MongoClientOptions(this);
        }
    }
}

