/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.client.AsyncAggregateIterable;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.internal.Publishers;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class AggregatePublisherImpl<TResult>
implements AggregatePublisher<TResult> {
    private final AsyncAggregateIterable<TResult> wrapped;

    AggregatePublisherImpl(AsyncAggregateIterable<TResult> wrapped) {
        this.wrapped = (AsyncAggregateIterable)Assertions.notNull((String)"wrapped", wrapped);
    }

    @Override
    public AggregatePublisher<TResult> allowDiskUse(Boolean allowDiskUse) {
        this.wrapped.allowDiskUse(allowDiskUse);
        return this;
    }

    @Override
    public AggregatePublisher<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        this.wrapped.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public AggregatePublisher<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        this.wrapped.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public AggregatePublisher<TResult> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.wrapped.bypassDocumentValidation(bypassDocumentValidation);
        return this;
    }

    @Override
    public Publisher<Void> toCollection() {
        return Publishers.publish(arg_0 -> this.wrapped.toCollection(arg_0));
    }

    @Override
    public AggregatePublisher<TResult> collation(Collation collation) {
        this.wrapped.collation(collation);
        return this;
    }

    @Override
    public AggregatePublisher<TResult> comment(String comment) {
        this.wrapped.comment(comment);
        return this;
    }

    @Override
    public AggregatePublisher<TResult> hint(Bson hint) {
        this.wrapped.hint(hint);
        return this;
    }

    @Override
    public AggregatePublisher<TResult> batchSize(int batchSize) {
        this.wrapped.batchSize(batchSize);
        return this;
    }

    @Override
    public Publisher<TResult> first() {
        return Publishers.publish(arg_0 -> this.wrapped.first(arg_0));
    }

    public void subscribe(Subscriber<? super TResult> s) {
        Publishers.publish(this.wrapped).subscribe(s);
    }
}

