/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoClientException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.WriteError;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteInsert;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropCollectionOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.SearchIndexModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.model.bulk.ClientBulkWriteOptions;
import com.mongodb.client.model.bulk.ClientBulkWriteResult;
import com.mongodb.client.model.bulk.ClientNamespacedWriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.bulk.WriteRequest;
import com.mongodb.internal.operation.IndexHelper;
import com.mongodb.internal.operation.Operations;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.internal.OperationExecutor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public final class MongoOperationPublisher<T> {
    private final Operations<T> operations;
    private final UuidRepresentation uuidRepresentation;
    @Nullable
    private final AutoEncryptionSettings autoEncryptionSettings;
    private final OperationExecutor executor;
    private static final Function<BulkWriteResult, InsertOneResult> INSERT_ONE_RESULT_MAPPER = result -> {
        if (result.wasAcknowledged()) {
            BsonValue insertedId = result.getInserts().isEmpty() ? null : ((BulkWriteInsert)result.getInserts().get(0)).getId();
            return InsertOneResult.acknowledged(insertedId);
        }
        return InsertOneResult.unacknowledged();
    };
    private static final Function<BulkWriteResult, InsertManyResult> INSERT_MANY_RESULT_MAPPER = result -> {
        if (result.wasAcknowledged()) {
            return InsertManyResult.acknowledged((Map)result.getInserts().stream().collect(HashMap::new, (m, v) -> m.put(v.getIndex(), v.getId()), HashMap::putAll));
        }
        return InsertManyResult.unacknowledged();
    };
    private static final Function<BulkWriteResult, DeleteResult> DELETE_RESULT_MAPPER = result -> {
        if (result.wasAcknowledged()) {
            return DeleteResult.acknowledged((long)result.getDeletedCount());
        }
        return DeleteResult.unacknowledged();
    };
    private static final Function<BulkWriteResult, UpdateResult> UPDATE_RESULT_MAPPER = result -> {
        if (result.wasAcknowledged()) {
            BsonValue upsertedId = result.getUpserts().isEmpty() ? null : ((BulkWriteUpsert)result.getUpserts().get(0)).getId();
            return UpdateResult.acknowledged((long)result.getMatchedCount(), (Long)Long.valueOf(result.getModifiedCount()), (BsonValue)upsertedId);
        }
        return UpdateResult.unacknowledged();
    };

    MongoOperationPublisher(Class<T> documentClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, boolean retryWrites, boolean retryReads, UuidRepresentation uuidRepresentation, @Nullable AutoEncryptionSettings autoEncryptionSettings, TimeoutSettings timeoutSettings, OperationExecutor executor) {
        this(new MongoNamespace("_ignored", "_ignored"), documentClass, codecRegistry, readPreference, readConcern, writeConcern, retryWrites, retryReads, uuidRepresentation, autoEncryptionSettings, timeoutSettings, executor);
    }

    MongoOperationPublisher(MongoNamespace namespace, Class<T> documentClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, boolean retryWrites, boolean retryReads, UuidRepresentation uuidRepresentation, @Nullable AutoEncryptionSettings autoEncryptionSettings, TimeoutSettings timeoutSettings, OperationExecutor executor) {
        this.operations = new Operations(namespace, (Class)Assertions.notNull((String)"documentClass", documentClass), (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference), (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry), (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern), (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern), retryWrites, retryReads, timeoutSettings);
        this.uuidRepresentation = (UuidRepresentation)Assertions.notNull((String)"uuidRepresentation", (Object)uuidRepresentation);
        this.autoEncryptionSettings = autoEncryptionSettings;
        this.executor = (OperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
    }

    MongoNamespace getNamespace() {
        return (MongoNamespace)Assertions.assertNotNull((Object)this.operations.getNamespace());
    }

    ReadPreference getReadPreference() {
        return this.operations.getReadPreference();
    }

    CodecRegistry getCodecRegistry() {
        return this.operations.getCodecRegistry();
    }

    ReadConcern getReadConcern() {
        return this.operations.getReadConcern();
    }

    WriteConcern getWriteConcern() {
        return this.operations.getWriteConcern();
    }

    public boolean getRetryWrites() {
        return this.operations.isRetryWrites();
    }

    public boolean getRetryReads() {
        return this.operations.isRetryReads();
    }

    @Nullable
    public Long getTimeoutMS() {
        return this.getTimeoutSettings().getTimeoutMS();
    }

    public TimeoutSettings getTimeoutSettings() {
        return this.operations.getTimeoutSettings();
    }

    Class<T> getDocumentClass() {
        return this.operations.getDocumentClass();
    }

    public Operations<T> getOperations() {
        return this.operations;
    }

    MongoOperationPublisher<T> withDatabase(String name) {
        return this.withDatabaseAndDocumentClass(name, this.getDocumentClass());
    }

    <D> MongoOperationPublisher<D> withDatabaseAndDocumentClass(String name, Class<D> documentClass) {
        return this.withNamespaceAndDocumentClass(new MongoNamespace((String)Assertions.notNull((String)"name", (Object)name), "_ignored"), (Class)Assertions.notNull((String)"documentClass", documentClass));
    }

    MongoOperationPublisher<T> withNamespace(MongoNamespace namespace) {
        return this.withNamespaceAndDocumentClass(namespace, this.getDocumentClass());
    }

    <D> MongoOperationPublisher<D> withDocumentClass(Class<D> documentClass) {
        return this.withNamespaceAndDocumentClass(this.getNamespace(), documentClass);
    }

    <D> MongoOperationPublisher<D> withNamespaceAndDocumentClass(MongoNamespace namespace, Class<D> documentClass) {
        if (this.getNamespace().equals((Object)namespace) && this.getDocumentClass().equals(documentClass)) {
            return this;
        }
        return new MongoOperationPublisher<T>((MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace), (Class)Assertions.notNull((String)"documentClass", documentClass), this.getCodecRegistry(), this.getReadPreference(), this.getReadConcern(), this.getWriteConcern(), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.autoEncryptionSettings, this.getTimeoutSettings(), this.executor);
    }

    MongoOperationPublisher<T> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoOperationPublisher<T>(this.getNamespace(), this.getDocumentClass(), CodecRegistries.withUuidRepresentation((CodecRegistry)((CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry)), (UuidRepresentation)this.uuidRepresentation), this.getReadPreference(), this.getReadConcern(), this.getWriteConcern(), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.autoEncryptionSettings, this.getTimeoutSettings(), this.executor);
    }

    MongoOperationPublisher<T> withReadPreference(ReadPreference readPreference) {
        if (this.getReadPreference().equals(readPreference)) {
            return this;
        }
        return new MongoOperationPublisher<T>(this.getNamespace(), this.getDocumentClass(), this.getCodecRegistry(), (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference), this.getReadConcern(), this.getWriteConcern(), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.autoEncryptionSettings, this.getTimeoutSettings(), this.executor);
    }

    MongoOperationPublisher<T> withWriteConcern(WriteConcern writeConcern) {
        if (this.getWriteConcern().equals((Object)writeConcern)) {
            return this;
        }
        return new MongoOperationPublisher<T>(this.getNamespace(), this.getDocumentClass(), this.getCodecRegistry(), this.getReadPreference(), this.getReadConcern(), (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.autoEncryptionSettings, this.getTimeoutSettings(), this.executor);
    }

    MongoOperationPublisher<T> withReadConcern(ReadConcern readConcern) {
        if (this.getReadConcern().equals((Object)readConcern)) {
            return this;
        }
        return new MongoOperationPublisher<T>(this.getNamespace(), this.getDocumentClass(), this.getCodecRegistry(), this.getReadPreference(), (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern), this.getWriteConcern(), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.autoEncryptionSettings, this.getTimeoutSettings(), this.executor);
    }

    MongoOperationPublisher<T> withTimeout(long timeout, TimeUnit timeUnit) {
        TimeoutSettings timeoutSettings = this.getTimeoutSettings().withTimeout(Long.valueOf(timeout), timeUnit);
        if (Objects.equals(this.getTimeoutSettings(), timeoutSettings)) {
            return this;
        }
        return new MongoOperationPublisher<T>(this.getNamespace(), this.getDocumentClass(), this.getCodecRegistry(), this.getReadPreference(), this.getReadConcern(), this.getWriteConcern(), this.getRetryWrites(), this.getRetryReads(), this.uuidRepresentation, this.autoEncryptionSettings, timeoutSettings, this.executor);
    }

    Publisher<Void> dropDatabase(@Nullable ClientSession clientSession) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.dropDatabase(), clientSession);
    }

    Publisher<Void> createCollection(@Nullable ClientSession clientSession, String collectionName, CreateCollectionOptions options) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.createCollection(collectionName, options, this.autoEncryptionSettings), clientSession);
    }

    Publisher<Void> createView(@Nullable ClientSession clientSession, String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions options) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.createView(viewName, viewOn, pipeline, options), clientSession);
    }

    public <R> Publisher<R> runCommand(@Nullable ClientSession clientSession, Bson command, ReadPreference readPreference, Class<R> clazz) {
        if (clientSession != null && clientSession.hasActiveTransaction() && !readPreference.equals(ReadPreference.primary())) {
            return Mono.error((Throwable)new MongoClientException("Read preference in a transaction must be primary"));
        }
        return this.createReadOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.commandRead(command, clazz), clientSession, (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference));
    }

    Publisher<Long> estimatedDocumentCount(EstimatedDocumentCountOptions options) {
        return this.createReadOperationMono(operations -> operations.createTimeoutSettings(options), () -> this.operations.estimatedDocumentCount((EstimatedDocumentCountOptions)Assertions.notNull((String)"options", (Object)options)), null);
    }

    Publisher<Long> countDocuments(@Nullable ClientSession clientSession, Bson filter, CountOptions options) {
        return this.createReadOperationMono(operations -> operations.createTimeoutSettings(options), () -> this.operations.countDocuments((Bson)Assertions.notNull((String)"filter", (Object)filter), (CountOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    Publisher<BulkWriteResult> bulkWrite(@Nullable ClientSession clientSession, List<? extends WriteModel<? extends T>> requests, BulkWriteOptions options) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.bulkWrite((List)Assertions.notNull((String)"requests", (Object)requests), (BulkWriteOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    Publisher<ClientBulkWriteResult> clientBulkWrite(@Nullable ClientSession clientSession, List<? extends ClientNamespacedWriteModel> clientWriteModels, @Nullable ClientBulkWriteOptions options) {
        Assertions.isTrue((String)"`autoEncryptionSettings` is null, as bulkWrite does not currently support automatic encryption", (this.autoEncryptionSettings == null ? 1 : 0) != 0);
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.clientBulkWriteOperation(clientWriteModels, options), clientSession);
    }

    Publisher<InsertOneResult> insertOne(@Nullable ClientSession clientSession, T document, InsertOneOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.insertOne(Assertions.notNull((String)"document", (Object)document), (InsertOneOptions)Assertions.notNull((String)"options", (Object)options)), clientSession, WriteRequest.Type.INSERT).map(INSERT_ONE_RESULT_MAPPER);
    }

    Publisher<InsertManyResult> insertMany(@Nullable ClientSession clientSession, List<? extends T> documents, InsertManyOptions options) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.insertMany((List)Assertions.notNull((String)"documents", (Object)documents), (InsertManyOptions)Assertions.notNull((String)"options", (Object)options)), clientSession).map(INSERT_MANY_RESULT_MAPPER);
    }

    Publisher<DeleteResult> deleteOne(@Nullable ClientSession clientSession, Bson filter, DeleteOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.deleteOne((Bson)Assertions.notNull((String)"filter", (Object)filter), (DeleteOptions)Assertions.notNull((String)"options", (Object)options)), clientSession, WriteRequest.Type.DELETE).map(DELETE_RESULT_MAPPER);
    }

    Publisher<DeleteResult> deleteMany(@Nullable ClientSession clientSession, Bson filter, DeleteOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.deleteMany((Bson)Assertions.notNull((String)"filter", (Object)filter), (DeleteOptions)Assertions.notNull((String)"options", (Object)options)), clientSession, WriteRequest.Type.DELETE).map(DELETE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> replaceOne(@Nullable ClientSession clientSession, Bson filter, T replacement, ReplaceOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.replaceOne((Bson)Assertions.notNull((String)"filter", (Object)filter), Assertions.notNull((String)"replacement", (Object)replacement), (ReplaceOptions)Assertions.notNull((String)"options", (Object)options)), clientSession, WriteRequest.Type.REPLACE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> updateOne(@Nullable ClientSession clientSession, Bson filter, Bson update, UpdateOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.updateOne((Bson)Assertions.notNull((String)"filter", (Object)filter), (Bson)Assertions.notNull((String)"update", (Object)update), (UpdateOptions)Assertions.notNull((String)"options", (Object)options)), clientSession, WriteRequest.Type.UPDATE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> updateOne(@Nullable ClientSession clientSession, Bson filter, List<? extends Bson> update, UpdateOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.updateOne((Bson)Assertions.notNull((String)"filter", (Object)filter), (List)Assertions.notNull((String)"update", (Object)update), (UpdateOptions)Assertions.notNull((String)"options", (Object)options)), clientSession, WriteRequest.Type.UPDATE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> updateMany(@Nullable ClientSession clientSession, Bson filter, Bson update, UpdateOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.updateMany((Bson)Assertions.notNull((String)"filter", (Object)filter), (Bson)Assertions.notNull((String)"update", (Object)update), (UpdateOptions)Assertions.notNull((String)"options", (Object)options)), clientSession, WriteRequest.Type.UPDATE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<UpdateResult> updateMany(@Nullable ClientSession clientSession, Bson filter, List<? extends Bson> update, UpdateOptions options) {
        return this.createSingleWriteRequestMono(() -> this.operations.updateMany((Bson)Assertions.notNull((String)"filter", (Object)filter), (List)Assertions.notNull((String)"update", (Object)update), (UpdateOptions)Assertions.notNull((String)"options", (Object)options)), clientSession, WriteRequest.Type.UPDATE).map(UPDATE_RESULT_MAPPER);
    }

    Publisher<T> findOneAndDelete(@Nullable ClientSession clientSession, Bson filter, FindOneAndDeleteOptions options) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.findOneAndDelete((Bson)Assertions.notNull((String)"filter", (Object)filter), (FindOneAndDeleteOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    Publisher<T> findOneAndReplace(@Nullable ClientSession clientSession, Bson filter, T replacement, FindOneAndReplaceOptions options) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.findOneAndReplace((Bson)Assertions.notNull((String)"filter", (Object)filter), Assertions.notNull((String)"replacement", (Object)replacement), (FindOneAndReplaceOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    Publisher<T> findOneAndUpdate(@Nullable ClientSession clientSession, Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.findOneAndUpdate((Bson)Assertions.notNull((String)"filter", (Object)filter), (Bson)Assertions.notNull((String)"update", (Object)update), (FindOneAndUpdateOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    Publisher<T> findOneAndUpdate(@Nullable ClientSession clientSession, Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.findOneAndUpdate((Bson)Assertions.notNull((String)"filter", (Object)filter), (List)Assertions.notNull((String)"update", (Object)update), (FindOneAndUpdateOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    Publisher<Void> dropCollection(@Nullable ClientSession clientSession, DropCollectionOptions dropCollectionOptions) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.dropCollection(dropCollectionOptions, this.autoEncryptionSettings), clientSession);
    }

    Publisher<String> createIndex(@Nullable ClientSession clientSession, Bson key, IndexOptions options) {
        return this.createIndexes(clientSession, Collections.singletonList(new IndexModel((Bson)Assertions.notNull((String)"key", (Object)key), options)), new CreateIndexOptions());
    }

    Publisher<String> createIndexes(@Nullable ClientSession clientSession, List<IndexModel> indexes, CreateIndexOptions options) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.createIndexes((List)Assertions.notNull((String)"indexes", (Object)indexes), (CreateIndexOptions)Assertions.notNull((String)"options", (Object)options)), clientSession).thenMany((Publisher)Flux.fromIterable((Iterable)IndexHelper.getIndexNames(indexes, (CodecRegistry)this.getCodecRegistry())));
    }

    Publisher<String> createSearchIndex(@Nullable String indexName, Bson definition) {
        SearchIndexModel searchIndexModel = indexName == null ? new SearchIndexModel(definition) : new SearchIndexModel(indexName, definition);
        return this.createSearchIndexes(Collections.singletonList(searchIndexModel));
    }

    Publisher<String> createSearchIndexes(List<SearchIndexModel> indexes) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.createSearchIndexes(indexes), null).thenMany((Publisher)Flux.fromIterable((Iterable)IndexHelper.getSearchIndexNames(indexes)));
    }

    public Publisher<Void> updateSearchIndex(String name, Bson definition) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.updateSearchIndex(name, definition), null);
    }

    public Publisher<Void> dropSearchIndex(String indexName) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.dropSearchIndex(indexName), null);
    }

    Publisher<Void> dropIndex(@Nullable ClientSession clientSession, String indexName, DropIndexOptions options) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.dropIndex((String)Assertions.notNull((String)"indexName", (Object)indexName), (DropIndexOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    Publisher<Void> dropIndex(@Nullable ClientSession clientSession, Bson keys, DropIndexOptions options) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.dropIndex((Bson)Assertions.notNull((String)"keys", (Object)keys), (DropIndexOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    Publisher<Void> dropIndexes(@Nullable ClientSession clientSession, DropIndexOptions options) {
        return this.dropIndex(clientSession, "*", options);
    }

    Publisher<Void> renameCollection(@Nullable ClientSession clientSession, MongoNamespace newCollectionNamespace, RenameCollectionOptions options) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), () -> this.operations.renameCollection((MongoNamespace)Assertions.notNull((String)"newCollectionNamespace", (Object)newCollectionNamespace), (RenameCollectionOptions)Assertions.notNull((String)"options", (Object)options)), clientSession);
    }

    <T> Mono<T> createReadOperationMono(Function<Operations<?>, TimeoutSettings> timeoutSettingsFunction, Supplier<ReadOperation<?, T>> operationSupplier, @Nullable ClientSession clientSession) {
        return this.createReadOperationMono(() -> (TimeoutSettings)timeoutSettingsFunction.apply(this.operations), operationSupplier, clientSession, this.getReadPreference());
    }

    <T> Mono<T> createReadOperationMono(Supplier<TimeoutSettings> timeoutSettingsSupplier, Supplier<ReadOperation<?, T>> operationSupplier, @Nullable ClientSession clientSession, ReadPreference readPreference) {
        ReadOperation<?, T> readOperation = operationSupplier.get();
        return this.getExecutor(timeoutSettingsSupplier.get()).execute(readOperation, readPreference, this.getReadConcern(), clientSession);
    }

    <R> Mono<R> createWriteOperationMono(Function<Operations<?>, TimeoutSettings> timeoutSettingsFunction, Supplier<WriteOperation<R>> operationSupplier, @Nullable ClientSession clientSession) {
        return this.createWriteOperationMono(() -> (TimeoutSettings)timeoutSettingsFunction.apply(this.operations), operationSupplier, clientSession);
    }

    <R> Mono<R> createWriteOperationMono(Supplier<TimeoutSettings> timeoutSettingsSupplier, Supplier<WriteOperation<R>> operationSupplier, @Nullable ClientSession clientSession) {
        WriteOperation<R> writeOperation = operationSupplier.get();
        return this.getExecutor(timeoutSettingsSupplier.get()).execute(writeOperation, this.getReadConcern(), clientSession);
    }

    private Mono<BulkWriteResult> createSingleWriteRequestMono(Supplier<WriteOperation<BulkWriteResult>> operation, @Nullable ClientSession clientSession, WriteRequest.Type type) {
        return this.createWriteOperationMono(() -> this.operations.getTimeoutSettings(), operation, clientSession).onErrorMap(MongoBulkWriteException.class, e -> {
            MongoWriteException exception;
            WriteConcernError writeConcernError = e.getWriteConcernError();
            if (e.getWriteErrors().isEmpty() && writeConcernError != null) {
                WriteConcernResult writeConcernResult = type == WriteRequest.Type.INSERT ? WriteConcernResult.acknowledged((int)e.getWriteResult().getInsertedCount(), (boolean)false, null) : (type == WriteRequest.Type.DELETE ? WriteConcernResult.acknowledged((int)e.getWriteResult().getDeletedCount(), (boolean)false, null) : WriteConcernResult.acknowledged((int)(e.getWriteResult().getMatchedCount() + e.getWriteResult().getUpserts().size()), (e.getWriteResult().getMatchedCount() > 0 ? 1 : 0) != 0, e.getWriteResult().getUpserts().isEmpty() ? null : ((BulkWriteUpsert)e.getWriteResult().getUpserts().get(0)).getId()));
                exception = new MongoWriteConcernException(writeConcernError, writeConcernResult, e.getServerAddress(), (Collection)e.getErrorLabels());
            } else {
                exception = !e.getWriteErrors().isEmpty() ? new MongoWriteException(new WriteError((WriteError)e.getWriteErrors().get(0)), e.getServerAddress(), (Collection)e.getErrorLabels()) : new MongoWriteException(new WriteError(-1, "Unknown write error", new BsonDocument()), e.getServerAddress(), (Collection)e.getErrorLabels());
            }
            return exception;
        });
    }

    private OperationExecutor getExecutor(TimeoutSettings timeoutSettings) {
        return this.executor.withTimeoutSettings(timeoutSettings);
    }

    public static <T> SingleResultCallback<T> sinkToCallback(MonoSink<T> sink) {
        return (result, t) -> {
            if (t != null) {
                sink.error(t);
            } else if (result == null) {
                sink.success();
            } else {
                sink.success(result);
            }
        };
    }
}

