/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jackson.dataformat;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.ContentReference;
import com.fasterxml.jackson.core.json.DupDetector;

public final class MessagePackReadContext
extends JsonStreamContext {
    protected final MessagePackReadContext parent;
    protected final DupDetector dups;
    protected int expEntryCount;
    protected String currentName;
    protected Object currentValue;
    protected MessagePackReadContext child = null;

    public MessagePackReadContext(MessagePackReadContext messagePackReadContext, DupDetector dupDetector, int n, int n2) {
        this.parent = messagePackReadContext;
        this.dups = dupDetector;
        this._type = n;
        this.expEntryCount = n2;
        this._index = -1;
        this._nestingDepth = messagePackReadContext == null ? 0 : messagePackReadContext._nestingDepth + 1;
    }

    protected void reset(int n, int n2) {
        this._type = n;
        this.expEntryCount = n2;
        this._index = -1;
        this.currentName = null;
        this.currentValue = null;
        if (this.dups != null) {
            this.dups.reset();
        }
    }

    public Object getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(Object object) {
        this.currentValue = object;
    }

    public static MessagePackReadContext createRootContext(DupDetector dupDetector) {
        return new MessagePackReadContext(null, dupDetector, 0, -1);
    }

    public MessagePackReadContext createChildArrayContext(int n) {
        MessagePackReadContext messagePackReadContext = this.child;
        if (messagePackReadContext == null) {
            this.child = messagePackReadContext = new MessagePackReadContext(this, this.dups == null ? null : this.dups.child(), 1, n);
        } else {
            messagePackReadContext.reset(1, n);
        }
        return messagePackReadContext;
    }

    public MessagePackReadContext createChildObjectContext(int n) {
        MessagePackReadContext messagePackReadContext = this.child;
        if (messagePackReadContext == null) {
            this.child = messagePackReadContext = new MessagePackReadContext(this, this.dups == null ? null : this.dups.child(), 2, n);
            return messagePackReadContext;
        }
        messagePackReadContext.reset(2, n);
        return messagePackReadContext;
    }

    public String getCurrentName() {
        return this.currentName;
    }

    public MessagePackReadContext getParent() {
        return this.parent;
    }

    public boolean hasExpectedLength() {
        return this.expEntryCount >= 0;
    }

    public int getExpectedLength() {
        return this.expEntryCount;
    }

    public boolean isEmpty() {
        return this.expEntryCount == 0;
    }

    public int getRemainingExpectedLength() {
        int n = this.expEntryCount - this._index;
        return Math.max(0, n);
    }

    public boolean acceptsBreakMarker() {
        return this.expEntryCount < 0 && this._type != 0;
    }

    public boolean expectMoreValues() {
        return ++this._index != this.expEntryCount;
    }

    public JsonLocation startLocation(ContentReference contentReference) {
        return new JsonLocation(contentReference, 1L, -1, -1);
    }

    @Deprecated
    public JsonLocation getStartLocation(Object object) {
        return this.startLocation(ContentReference.rawReference((Object)object));
    }

    public void setCurrentName(String string) throws JsonProcessingException {
        this.currentName = string;
        if (this.dups != null) {
            this._checkDup(this.dups, string);
        }
    }

    private void _checkDup(DupDetector dupDetector, String string) throws JsonProcessingException {
        if (dupDetector.isDup(string)) {
            throw new JsonParseException(null, "Duplicate field '" + string + "'", dupDetector.findLocation());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                stringBuilder.append("/");
                break;
            }
            case 1: {
                stringBuilder.append('[');
                stringBuilder.append(this.getCurrentIndex());
                stringBuilder.append(']');
                break;
            }
            case 2: {
                stringBuilder.append('{');
                if (this.currentName != null) {
                    stringBuilder.append('\"');
                    CharTypes.appendQuoted((StringBuilder)stringBuilder, (String)this.currentName);
                    stringBuilder.append('\"');
                } else {
                    stringBuilder.append('?');
                }
                stringBuilder.append('}');
            }
        }
        return stringBuilder.toString();
    }
}

